/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.enums;

import java.util.HashMap;
import java.util.Map;

public enum CaseCarTypeEnum {
    TYPE_1_PASSENGER("1", "\u4e00\u578b\u5ba2\u8f66", 1, 1),
    TYPE_2_PASSENGER("2", "\u4e8c\u578b\u5ba2\u8f66", 1, 2),
    TYPE_3_PASSENGER("3", "\u4e09\u578b\u5ba2\u8f66", 1, 3),
    TYPE_4_PASSENGER("4", "\u56db\u578b\u5ba2\u8f66", 1, 4),
    TYPE_1_TRUCK("11", "\u4e00\u578b\u8d27\u8f66", 2, 1),
    TYPE_2_TRUCK("12", "\u4e8c\u578b\u8d27\u8f66", 2, 2),
    TYPE_3_TRUCK("13", "\u4e09\u578b\u8d27\u8f66", 2, 3),
    TYPE_4_TRUCK("14", "\u56db\u578b\u8d27\u8f66", 2, 4),
    TYPE_5_TRUCK("15", "\u4e94\u578b\u8d27\u8f66", 2, 5),
    TYPE_6_TRUCK("16", "\u516d\u578b\u8d27\u8f66", 2, 6);

    private final String code;
    private final String name;
    private final Integer carClass;
    private final Integer carType;

    public static Map<Integer, Integer> getCarClassAndTypeByCode(String code) {
        HashMap<Integer, Integer> map = null;
        for (CaseCarTypeEnum e : CaseCarTypeEnum.values()) {
            if (!e.getCode().equalsIgnoreCase(code)) continue;
            map = new HashMap<Integer, Integer>();
            map.put(e.getCarClass(), e.getCarType());
        }
        return map;
    }

    public static String getCodeByCarType(Integer carType) {
        for (CaseCarTypeEnum e : CaseCarTypeEnum.values()) {
            if (!e.getCarType().equals(carType)) continue;
            return e.getCode();
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getCarClass() {
        return this.carClass;
    }

    public Integer getCarType() {
        return this.carType;
    }

    private CaseCarTypeEnum(String code, String name, Integer carClass, Integer carType) {
        this.code = code;
        this.name = name;
        this.carClass = carClass;
        this.carType = carType;
    }
}

