/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.config;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.conf.NettyConfig;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.webSocket.SubroutineManage;
import com.artfess.base.webSocket.WebScoketMsg;
import com.artfess.rescue.patrol.manager.BizInspectionVideoManager;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class RescueWebSocketHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private static final Logger log = LoggerFactory.getLogger(RescueWebSocketHandler.class);
    public static int online;
    private static final String VIDEO_TASK_TYPE = "video_task";
    @Resource
    private BizInspectionVideoManager inspectionVideoManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (!NettyConfig.getChannelGroup().contains((Object)channel)) {
            NettyConfig.getChannelGroup().add((Object)channel);
            online = NettyConfig.getChannelGroup().size();
            log.info("\u3010webSocket\u3011\uff1a{} \u4e0a\u7ebf\uff0c\u5f53\u524d\u5728\u7ebf\u4eba\u6570\uff1a{}", (Object)channel.remoteAddress(), (Object)online);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame frame) throws Exception {
        String message;
        SubroutineManage subroutineManage = (SubroutineManage)AppUtil.getBean(SubroutineManage.class);
        TextWebSocketFrame txFrame = frame;
        log.trace("\u3010webSocket\u3011\uff1a\u670d\u52a1\u5668\u63a5\u6536\u5230\uff1a{}", (Object)("\u6765\u81ea\uff1a\u3010" + ctx.channel().remoteAddress() + "\u3011 \u7684\u6570\u636e\uff1a" + txFrame.text()));
        WebScoketMsg msgContent = (WebScoketMsg)JSONUtil.toBean((String)txFrame.text(), WebScoketMsg.class);
        String messageType = msgContent.getMessageType();
        String account = msgContent.getSender();
        if (StringUtil.isNotEmpty((String)account)) {
            LinkedHashSet<ChannelId> channelIdList = (LinkedHashSet<ChannelId>)NettyConfig.getUserChanIdMap().get(account);
            if (BeanUtils.isNotEmpty((Object)channelIdList)) {
                channelIdList.add(ctx.channel().id());
            } else {
                channelIdList = new LinkedHashSet<ChannelId>();
                channelIdList.add(ctx.channel().id());
                NettyConfig.getUserChanIdMap().put(account, channelIdList);
            }
        }
        if (messageType.equals("ping")) {
            message = msgContent.getMessage();
            NettyConfig.getSubroutineChanIdMap().put(ctx.channel().id().asShortText(), message);
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("msgTxt", "\u5fc3\u8df3\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.now());
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(obj.toString()));
        } else if (messageType.equals("topic")) {
            message = msgContent.getMessage();
            NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(message));
        } else if (messageType.equals("msg")) {
            String jsrAccounts = msgContent.getReceiver();
            if (StringUtil.isNotEmpty((String)jsrAccounts)) {
                String[] accountStr;
                for (String jsraccount : accountStr = jsrAccounts.split(",")) {
                    Set channelIdList = (Set)NettyConfig.getUserChanIdMap().get(jsraccount);
                    if (!BeanUtils.isNotEmpty((Object)channelIdList)) continue;
                    for (ChannelId chanId : channelIdList) {
                        Channel userChannel = NettyConfig.getChannelGroup().find(chanId);
                        if (userChannel == null) continue;
                        userChannel.writeAndFlush((Object)new TextWebSocketFrame(msgContent.getMessage()));
                    }
                }
            }
        } else if (VIDEO_TASK_TYPE.equals(messageType)) {
            message = msgContent.getMessage();
            String userId = msgContent.getSender();
            JSONObject jsonObject = JSONObject.parseObject((String)message);
            Integer time = jsonObject.getInteger("time");
            JSONArray jsonIds = jsonObject.getJSONArray("ids");
            if (CollectionUtils.isEmpty((Collection)jsonIds) || time == null) {
                log.info("webSocket\u63a5\u6536\u53c2\u6570\u5f02\u5e38\uff01userId:{},time:{},ids:{}", new Object[]{userId, time, jsonIds});
                return;
            }
            List ids = IntStream.range(0, jsonIds.size()).mapToObj(arg_0 -> ((JSONArray)jsonIds).getString(arg_0)).collect(Collectors.toList());
            this.executorService.execute(() -> {
                try {
                    this.inspectionVideoManager.inspect(userId, time, ids);
                }
                catch (Exception e) {
                    log.info("webSocket\u5f02\u6b65\u6279\u91cf\u4fdd\u5b58\u5de1\u68c0\u7ed3\u679c\u5931\u8d25\uff0c\u53c2\u6570 userId:{},time:{},ids:{}", new Object[]{userId, time, ids});
                }
            });
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        log.trace("\u3010webSocket\u3011\uff1ahandlerRemoved \u88ab\u8c03\u7528" + ctx.channel().id().asLongText());
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        online = NettyConfig.getChannelGroup().size();
        this.removeUserId(ctx);
        log.trace("\u3010webSocket\u3011\uff1a========\u4e0b\u7ebf\uff1a\u5728\u7ebf\u4eba\u6570\uff1a" + online + "!========");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u3010webSocket\u3011\uff1a\u5f02\u5e38\uff1a{}", (Object)cause.getMessage(), (Object)cause);
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        this.removeUserId(ctx);
        ctx.close();
    }

    private void removeUserId(ChannelHandlerContext ctx) {
        AttributeKey key = AttributeKey.valueOf((String)"account");
        String account = (String)ctx.channel().attr(key).get();
        if (StringUtil.isNotEmpty((String)account)) {
            Set channelIdList = (Set)NettyConfig.getUserChanIdMap().get(account);
            if (BeanUtils.isNotEmpty((Object)channelIdList)) {
                channelIdList.remove(ctx.channel().id());
            }
            if (channelIdList.size() == 0) {
                NettyConfig.getUserChanIdMap().remove(account);
            }
        }
        NettyConfig.getSubroutineChanIdMap().remove(ctx.channel().id().asShortText());
        log.info("\u3010webSocket\u3011\uff1a" + ctx.channel().remoteAddress() + "\u65ad\u5f00\u8fde\u63a5!");
    }

    public void sendUserNotLoginMsg(ChannelHandlerContext ctx) {
        ChannelFuture future = ctx.writeAndFlush((Object)new CloseWebSocketFrame(WebSocketCloseStatus.POLICY_VIOLATION, "\u672a\u767b\u5f55\uff01"));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

