/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.rescue.base.dao.BizBaseTeamMemberDao;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.manager.BizBaseTeamMemberManager;
import com.artfess.rescue.base.manager.BizBindMemberManager;
import com.artfess.rescue.base.model.BizBaseTeamMember;
import com.artfess.rescue.base.model.BizBindMember;
import com.artfess.rescue.uc.manager.RescueOrgUserManager;
import com.artfess.rescue.uc.manager.RescuePwdStrategyManager;
import com.artfess.rescue.uc.manager.RescueRoleManager;
import com.artfess.rescue.uc.manager.RescueUserManager;
import com.artfess.rescue.uc.manager.RescueUserRoleManager;
import com.artfess.rescue.uc.model.OrgUser;
import com.artfess.rescue.uc.model.Role;
import com.artfess.rescue.uc.model.User;
import com.artfess.rescue.uc.model.UserRole;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BizBaseTeamMemberManagerImpl
extends BaseManagerImpl<BizBaseTeamMemberDao, BizBaseTeamMember>
implements BizBaseTeamMemberManager {
    @Autowired
    RescuePwdStrategyManager pwdStrategyManager;
    @Autowired
    RescueUserManager userManager;
    @Autowired
    RescueRoleManager roleManager;
    @Autowired
    RescueUserRoleManager userRoleManager;
    @Autowired
    RescueOrgUserManager orgUserService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    BizBaseTeamManager teamManager;
    @Resource
    BizBindMemberManager bindMemberManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizBaseTeamMember member) {
        this.validateMember(member);
        this.checkExistingUser(member.getTel());
        String orgId = this.determineOrgId(member);
        Role role = this.setRole(member.getType(), member.getPost());
        if (role == null) {
            throw new BaseException("\u672a\u627e\u5230\u76f8\u5e94\u89d2\u8272\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        User user = this.createOrGetUser(member);
        this.saveMemberInfo(member, user);
        this.processUserRelations(user.getId(), role.getId(), orgId);
        return true;
    }

    Role setRole(String type, String post) {
        Role role = new Role();
        if (type.equals("1")) {
            role = post.equals("1") ? this.roleManager.getByAlias("lxbz") : this.roleManager.getByAlias("xjry");
        } else if (type.equals("2")) {
            role = this.roleManager.getByAlias("jyry");
        }
        return role;
    }

    private void validateMember(BizBaseTeamMember member) {
        if (member == null || StringUtils.isEmpty((Object)member.getTel())) {
            throw new BaseException("\u6210\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
    }

    private void checkExistingUser(String tel) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizBaseTeamMember::getAccount, (Object)tel);
        if (this.count((Wrapper)wrapper) > 0) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
    }

    private String determineOrgId(BizBaseTeamMember member) {
        String orgId;
        String string = orgId = "0".equals(member.getIsOut()) ? this.teamManager.getOrgByRoad(member.getRoadId()) : this.teamManager.getOutById(member.getOrgId(), member.getType());
        if (StringUtils.isEmpty((Object)orgId)) {
            throw new BaseException("\u672a\u627e\u5230\u76f8\u5e94\u961f\u4f0d\u53ca\u7ec4\u7ec7");
        }
        return orgId;
    }

    private User createOrGetUser(BizBaseTeamMember member) {
        User user = this.userManager.getByAccount(member.getTel());
        if (user == null) {
            user = new User();
            user.setUserType(2);
            user.setUserLevel(1);
            user.setFullname(member.getName());
            user.setPassword(this.passwordEncoder.encode((CharSequence)this.pwdStrategyManager.getDefault().getInitPwd()));
            user.setAccount(member.getTel());
            user.setMobile(member.getTel());
            user.setStatus(1);
            user.setCreateTime(LocalDateTime.now());
            user.setFrom("member");
            user.setPwdCreateTime(LocalDateTime.now());
            user.setLockedStatus(1);
            user.setIsDelete("0");
            this.userManager.save(user);
        }
        return user;
    }

    private void saveMemberInfo(BizBaseTeamMember member, User user) {
        member.setAccount(member.getTel());
        member.setUserId(user.getId());
        this.save((Object)member);
    }

    private void processUserRelations(String userId, String roleId, String orgId) {
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        ArrayList<OrgUser> orgUserList = new ArrayList<OrgUser>();
        try {
            if (!this.userRoleManager.checkSameUserRole(userId, roleId)) {
                userRoleList.add(this.createUserRole(userId, roleId));
            }
            if (!this.orgUserService.checkOrgUser(orgId, userId)) {
                orgUserList.add(this.createOrgUser(orgId, userId));
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5904\u7406\u7528\u6237\u5173\u7cfb\u65f6\u51fa\u9519: " + e.getMessage(), (Throwable)e);
        }
        if (!CollectionUtils.isEmpty(userRoleList)) {
            this.userRoleManager.saveBatch(userRoleList);
        }
        if (!CollectionUtils.isEmpty(orgUserList)) {
            this.orgUserService.saveBatch(orgUserList);
        }
    }

    private UserRole createUserRole(String userId, String roleId) {
        UserRole userRole = new UserRole();
        userRole.setId(UniqueIdUtil.getSuid());
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        return userRole;
    }

    private OrgUser createOrgUser(String orgId, String userId) {
        OrgUser orgUser = new OrgUser();
        orgUser.setId(UniqueIdUtil.getSuid());
        orgUser.setUserId(userId);
        orgUser.setOrgId(orgId);
        orgUser.setIsRelActive(1);
        orgUser.setIsCharge(0);
        orgUser.setIsMaster(0);
        return orgUser;
    }

    @Override
    public String getMemberId(String userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BizBaseTeamMember::getUserId, (Object)userId)).last("limit 1");
        BizBaseTeamMember member = (BizBaseTeamMember)((Object)this.getOne((Wrapper)wrapper));
        if (member != null) {
            return member.getId();
        }
        return "";
    }

    @Override
    public PageList<BizBaseTeamMember> authByPage(QueryFilter<BizBaseTeamMember> queryFilter) {
        queryFilter.addFilter("tm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizBaseTeamMember> iPage = ((BizBaseTeamMemberDao)this.baseMapper).authByPage((IPage<BizBaseTeamMember>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBaseTeamMember>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByIds(List<String> ids) {
        LambdaQueryWrapper teamCarWrapper = new LambdaQueryWrapper();
        teamCarWrapper.in(BizBindMember::getMemberId, ids);
        this.bindMemberManager.remove((Wrapper)teamCarWrapper);
        LambdaQueryWrapper carWrapper = new LambdaQueryWrapper();
        carWrapper.in(BizBaseTeamMember::getId, ids);
        return this.remove((Wrapper)carWrapper);
    }

    @Override
    public List<BizBaseTeamMember> getMemberById(String teamId) {
        return ((BizBaseTeamMemberDao)this.baseMapper).getMemberById(teamId);
    }

    public BizBaseTeamMember getById(Serializable id) {
        return ((BizBaseTeamMemberDao)this.baseMapper).findById(id);
    }

    public PageList<BizBaseTeamMember> query(QueryFilter<BizBaseTeamMember> queryFilter) {
        queryFilter.addFilter("tm.is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizBaseTeamMember> iPage = ((BizBaseTeamMemberDao)this.baseMapper).query((IPage<BizBaseTeamMember>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBaseTeamMember>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }
}

