import axios from 'axios'

const url = window.context.portal

// 经纬度转桩号
export async function lngAndLatToPie(data) {
  try {
    const res = await axios.get(url + '/common/v1/route/pointMapping',{
        params: data
    })
    if (res.data.value.indexOf('暂无对应点位') === -1) {
      let { stakeNum } = JSON.parse(res.data.value)
      let stakeArr = stakeNum.toString().split('.')
      return {
        state: true,
        stakeNum1: stakeArr[0],
        stakeNum2: stakeArr[1]
      }
    } else {
      return {
        state: false,
        message: '暂无对应点位！'
      }
    }
  } catch (e) {
    return ''
  }
}

// 桩号转经纬度
export async function pieTolngAndLat(data) {
  try {
    const res = await axios.get(url + '/common/v1/route/mappingPoint',{
        params: data
    })
    return res.data
  } catch (e) {
    return ''
  }
}
