// 自定义后台路由（不需要在后台做管理的）
export default [
  // 个人信息
  {
    path: 'personalInfo',
    name: 'personalInfo',
    props: true,
    component: () => import('@/views/systemDefaultPage/PersonalInfo.vue'),
    meta: {
      breadcrumbName: '个人信息',
      customSystemRouter: true
    }
  },
  // 重置密码
  {
    path: 'resetPwdView',
    name: 'resetPwdViewInner',
    props: true,
    component: () => import('@/views/systemDefaultPage/ResetPwdView.vue'),
    meta: {
      breadcrumbName: '修改密码',
      customSystemRouter: true
    }
  },
  // 消息提醒
  {
    path: 'messageReminder',
    name: 'messageReminder',
    props: true,
    component: () => import('@/views/MessageReminder/index.vue'),
    meta: {
      breadcrumbName: '消息提醒',
      customSystemRouter: true
    }
  },
  /* 首页 */
  {
    path: 'homePage',
    name: 'homePage',
    component: () => import('@/views/HomePage/index.vue'),
    meta: {}
  },
  // 任务管理
  {
    path: 'taskList',
    name: 'taskList',
    props: true,
    component: () => import('@/views/HomePage/subPages/taskList.vue'),
    meta: {}
  },
  // 信息管理
  {
    path: 'infoList',
    name: 'infoList',
    props: true,
    component: () => import('@/views/HomePage/subPages/infoList.vue'),
    meta: {}
  },
  // 详情界面
  {
    path: 'detailsPage',
    name: 'detailsPage',
    props: true,
    component: () => import('@/views/HomePage/subPages/detailsPage.vue'),
    meta: {}
  },

  // 问题工单新增
  {
    path: 'workAddPage',
    name: 'workAddPage',
    props: true,
    component: () => import('@/views/WorkOrder/AddEdit.vue'),
    meta: {}
  },
  // 问题工单列表
  {
    path: 'workListPage',
    name: 'workListPage',
    props: true,
    component: () => import('@/views/WorkOrder/WorkList.vue'),
    meta: {}
  },
  // 问题工单详情
  {
    path: 'workDetailPage',
    name: 'workDetailPage',
    props: true,
    component: () => import('@/views/WorkOrder/Details.vue'),
    meta: {}
  },
  // 资源列表
  {
    path: 'resourceListPage',
    name: 'resourceListPage',
    props: true,
    component: () => import('@/views/YunSearcher/ResourceList.vue'),
    meta: {}
  },
  // 资源新增、编辑
  {
    path: 'resourceAddEditPage',
    name: 'resourceAddEditPage',
    props: true,
    component: () => import('@/views/YunSearcher/ResourceDetails.vue'),
    meta: {}
  },

]
