import 'babel-polyfill'
import Vue from 'vue'
import App from './App.vue'
import store from './store'
import router from './router/router'
import i18n from '@/lang/index.js'
import JsonExcel from 'vue-json-excel'
import validate from '@/validate.js'
import dict from '@/lang/dict.js'
import req from '@/request'
import DictSelect from '@/components/dict/DictSelect.vue'
import dictUtils from '@/components/dict/DictSelectUtils'
import StatusByColor from '@/components/common/StatusByColor.vue'
import svgIcon from '@/components/global/svgIcon.vue'
import qs from 'qs'
import ElementUI from 'element-ui'
import countTo from 'vue-count-to'
import uploader from 'vue-simple-uploader'
import eventBus from './utils/bus.js'
import moment from 'moment'
import videoJs from 'video.js'
import deepmerge from 'deepmerge'
import { VueMasonryPlugin } from 'vue-masonry'
import * as Quill from 'quill'
import { ImageDrop } from 'quill-image-drop-module'
import ImageResize from 'quill-image-resize-module'
import dataV from '@jiaminghi/data-view'
import quillEditor from 'vue-quill-editor'
import roadCascader from '@/components/roadCascader/index.vue'
import companyCascader from '@/components/companyCascader/index.vue'
import '@/directive.js'
import '@/assets/css/element-custom.scss'
import '@/assets/css/public-style.scss'
import 'quill/dist/quill.core.css'
import 'quill/dist/quill.snow.css'
import 'quill/dist/quill.bubble.css'
import 'video.js/dist/video-js.css'
import 'videojs-contrib-hls'

// 设置全局配置
Vue.config.debug = true
Vue.prototype.$http = req
Vue.prototype.$videoJs = videoJs
Vue.prototype.qs = qs
Vue.prototype.$tooltipplacement = 'bottom'

// 注册全局组件
Vue.component('downloadExcel', JsonExcel)
Vue.component('CountTo', countTo)
Vue.component('svgIcon', svgIcon)
Vue.component('DictSelect', DictSelect)
Vue.component('StatusByColor', StatusByColor)
Vue.component('roadCascader', roadCascader)
Vue.component('companyCascader', companyCascader)

// 使用插件
Vue.use(uploader)
Vue.use(VueMasonryPlugin)
Vue.use(quillEditor)
Vue.use(dataV)
Vue.use(eventBus)

Quill.register('modules/imageDrop', ImageDrop)
Quill.register('modules/imageResize', ImageResize)

// ElementUI 配置
Vue.use(ElementUI, {
    i18n: (key, value) => i18n.t(key, value)
})

// 列头自适应
ElementUI.TableColumn.props.minWidth = {
    default: function () {
        if (this.label) {
            return this.label.replace(/[^\x00-\xff]/g, 'aa').length * 7.8 + 20 + 'px'
        }
    }
}

// 获取字典数据
Vue.prototype.getDictData = dictCode => {
    const arr = []
    const dictItems = dictUtils.getDictItemsFromCache(dictCode)
    dictItems.forEach(item => {
        arr.push({
            text: item.name,
            value: item.value
        })
    })
    return arr
}

// 获取当前日期并格式化为 yyyy-MM-dd
Vue.prototype.getDate = _ => moment().format('YYYY-MM-DD')

// 设置日期控件格式化
const validateLocal = localStorage.getItem('lang')
const currentLocal = validateLocal || 'zh-CN'
moment.locale(currentLocal === 'zh-CN' ? 'zh-cn' : 'en')
moment.locale('zh-cn')

// 地图全局配置
/*
if (minemap) {
  minemap.domainUrl = 'https://map.hope.cmet1965.com:58000' /!* MineMap根域名地址 *!/
  /!* MineMap矢量数据服务根域名地址 *!/
  minemap.dataDomainUrl = 'https://map.hope.cmet1965.com:58000'
  /!* MineMap矢量数据服务新规范根域名地址 *!/
  minemap.serverDomainUrl = 'https://map.hope.cmet1965.com:58000'
  /!* MineMap底图雪碧图地址 *!/
  minemap.spriteUrl = ['https://map.hope.cmet1965.com:58000/minemapapi/zsxz/zsxz'] // "./mapresource/sprite/sprite",
  /!* MineMap后台服务根地址 *!/
  minemap.serviceUrl = 'https://map.hope.cmet1965.com:58000/service/'
}
*/

// 创建 Vue 实例并挂载到 #root
window.app = new Vue({
    store,
    router,
    i18n,
    render: createElement => createElement(App)
}).$mount('#root')

// 配置 VeeValidate
if (app.$validator) {
    for (const rule in validate) {
        app.$validator.rules[rule] = validate[rule]
    }
    app.$validator.dictionary.container = deepmerge(
        dict,
        app.$validator.dictionary.container,
        { clone: true }
    )
}

// 处理 IE 特殊情况
if ('-ms-scroll-limit' in document.documentElement.style && '-ms-ime-align' in document.documentElement.style) {
    window.addEventListener('hashchange', () => {
        const currentPath = window.location.hash.slice(1)
        if (app.$route.path !== currentPath) {
            app.$router.push(currentPath)
        }
    }, false)
}

export default window.app
