import req from '@/request'
import { createAutoCancelRequest } from '@/utils/helpers'

const portal = window.context.portal

// 用户是否已填写个人信息
export function getUserInfoState() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizUserExtend/v1/isExist`)
            .then(res => resolve(res.data))
            .catch(err => reject(err))
    })
}

// 系统用户列表
export function getOrgUserQuery(data = {}) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/user/v1/users/getOrgUserQuery`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 获取岗位下人员列表
export function getOrgUserPage(data = {}) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/org/v1/orgUsers/getOrgUserPage`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}


// 岗位列表
export function getOrgPostPage(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/org/v1/orgPosts/getOrgPostPage`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 群组列表
export function getGroupPage(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/userGroup/v1/getUserGroupPageByCreator`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 新增群组
export function addGroup(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/userGroup/v1/userGroup/addUserGroup`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 编辑群组
export function editGroup(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/api/userGroup/v1/userGroup/updateUserGroup`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 获取群组详情
export function getGroupDetail(code) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/api/userGroup/v1/userGroup/getUserGroup?code=` + code)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 删除群组详情
export function deleteGroup(code) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/userGroup/v1/userGroup/delUserGroup`, code)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 获取群组人员
export function getGroupUser(code) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/api/userGroup/v1/userGroup/getGroupUsers?code=${code}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 添加群组人员
export function addGroupUser(code, user) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/userGroup/v1/userGroup/addGroupUsers?code=${code}`, user)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
// 获得单位树
export function orgTree() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/api/org/v1/user/getOrgTree?demCode=ljjt`)
            .then(res => resolve(res.data || []))
            .catch(err => reject(err))
    })
}

// 获得组织树
export function treeDataByDem() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/api/org/v1/user/getOrgTree?demCode=ljjt`)
            .then(res => resolve(res.data || []))
            .catch(err => reject(err))
    })
}

// 获得组织列表
export function getOrgPage(data = {}) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/org/v1/orgs/getOrgPage`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 文件下载/预览
export function downloadFiles(fileId) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/file/v1/downloadFile?fileId=${fileId}`, 'blob')
            .then(res => resolve(res || {}))
            .catch(err => reject(err))
    })
}

// 附件在线预览
export function onlinePreview(fileId = '') {
    return new Promise((resolve, reject) => {
        req.get(portal + `/file/onlinePreviewController/v1/onlinePreview?fileId=${fileId}`)
            .then(res => resolve(res.data || {}))
            .catch(err => reject(err))
    })
}

// 分片初始化
export function initFile(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/file/v1/init`, data, undefined, 0)
            .then(res => resolve(res.data || {}))
            .catch(err => reject(err))
    })
}

// 分片合并
export function completeUpload(uploadId) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/file/v1/completeUpload`, { uploadId }, undefined, 0)
            .then(res => resolve(res.data || {}))
            .catch(err => reject(err))
    })
}

// 获取路段数据
export function queryRoadData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/road/roadmanage/v1/getJson`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 获取公司树数据
export function queryCompanyData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

/**
 * 通过中文获取编码
 * */
export const getCodeRequest = createAutoCancelRequest(`/base/tools/v1/getPinyin`)


// 获取视频区域目录数据
export function queryVideoAreaData() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizVideoAreaInfo/v1/getTree`)
            .then(res => resolve(res?.data?.value || []))
            .catch(err => reject(err))
    })
}

// 获取视频区域目录数据
export function queryVideoPointData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizVideoMonitorPointInfo/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}