import req from '@/request'
import {createAutoCancelRequest} from '@/utils/helpers'

const portal = window.context.portal

/**
 * 表格分页接口函数
 * */
// export const tableData = createAutoCancelRequest({
//   method: 'POST',
//   url: '/bizBaseRoadsideFacilities/v1/query'
// })

export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseRoadsideFacilities/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseRoadsideFacilities/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 同步数据
export function synchroData() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseRoadsideFacilities/v1/SynchronizeData`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


