package com.artfess.sysConfig.persistence.dao;


import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典详情信息
 */
public interface SysDictionaryDetailDao extends BaseMapper<SysDictionaryDetail> {

    /**
    * @Description: 通过查询指定code 获取字典
    * @Param: code
    * @Param: tenantId
    * @Return: java.util.List<com.artfess.portal.params.DictModel>
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    List<DictModel> queryDictModelItemsByCode(@Param("code") String code, @Param("tenantId") String tenantId);

    /**
    * @Description: 通过上级字典项的值与其下级级联字典的id，获取级联的字典项数据
    * @Param: dictLowerId
    * @Param: detailId  
    * @Return: java.util.List<com.artfess.portal.model.SysDictionaryDetail>
    * @Author: ZQF 
    * @Date: 2021/3/17 
    */
    List<SysDictionaryDetail> queryLowerDictionaryDetail(@Param("dictLowerId") String dictLowerId, @Param("detailId")String detailId);

    /**
    * @Description: 根据id集合修改字典明细状态
    * @Param: idsList
    * @Param: status  
    * @Return: void
    * @Author: ZQF 
    * @Date: 2021/3/17 
    */
    void updateDictionariesDetailsStatus(@Param("ids") List<String> idsList, @Param("status") Integer status);

    /**
    * @Description: 根据code查询字典明细状态
    * @Param: code
    * @Param: tenantId  
    * @Return: java.util.List<com.artfess.portal.model.SysDictionaryDetail>
    * @Author: ZQF 
    * @Date: 2021/3/17 
    */
    List<SysDictionaryDetail> queryDictItemsByCode(@Param("code") String code, @Param("tenantId") String tenantId);
}
