package com.artfess.service.parse.impl;

import com.artfess.base.util.StringUtil;
import com.artfess.service.parse.ServiceBean;
import com.artfess.service.parse.ServiceParser;
import com.artfess.service.ws.WebServiceClient;
import com.artfess.service.ws.model.SoapService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class ServiceParserImpl implements ServiceParser{
	@Resource
	private WebServiceClient webServiceClient;
	
	public ServiceBean parse(String url) {
		if(StringUtil.isEmpty(url))return null;
		if(url.matches(".*\\?wsdl$")){
			ServiceBean serviceBean = new ServiceBean();
			SoapService soapService = webServiceClient.parse(url);
			serviceBean.setUrl(url);
			serviceBean.setName(soapService.getName());
			serviceBean.setNamespace(soapService.getNamespace());
			serviceBean.setSoapService(soapService);
			return serviceBean;
		}
		return null;
	}
}