/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NoExecutorModel;
import com.artfess.bpm.api.event.NodeNotifyEvent;
import com.artfess.bpm.api.event.NodeNotifyModel;
import com.artfess.bpm.api.event.TaskCreateEvent;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.service.BpmAgentService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.exception.NoTaskUserException;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.BpmTaskDueTime;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TaskCreateEventListener
implements ApplicationListener<TaskCreateEvent>,
Ordered {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmAgentService bpmAgentService;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmProcessInstanceManager instanceManager;
    @Resource
    ActTaskManager actTaskManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskCreateEvent ev) {
        try {
            boolean isAllowEmptyIdentity;
            BpmProcessInstance instance;
            JsonNode jsonNode;
            Map<String, Object> variables;
            String nodeUserStr;
            BpmDelegateTask delegateTask = (BpmDelegateTask)ev.getSource();
            String instId = (String)delegateTask.getVariable("instanceId_");
            String subject = (String)delegateTask.getVariable("subject_");
            String nodeId = delegateTask.getTaskDefinitionKey();
            ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
            if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
                ThreadMsgUtil.addMapMsg((String)"bpmTask_", (String)delegateTask.getId());
            }
            ArrayList<BpmIdentity> identityList = new ArrayList();
            Map nodeUsers = (Map)taskCmd.getTransitVars("bpm_node_users_");
            if (BeanUtils.isEmpty((Object)nodeUsers) && StringUtil.isNotEmpty((String)(nodeUserStr = (String)(variables = taskCmd.getVariables()).get("bpm_node_users_"))) && (jsonNode = JsonUtil.toJsonNode((String)nodeUserStr)).has(nodeId)) {
                ArrayNode jsonNode2 = (ArrayNode)jsonNode.get(nodeId);
                for (JsonNode jsonNode3 : jsonNode2) {
                    DefaultBpmIdentity identity = (DefaultBpmIdentity)JsonUtil.toBean((JsonNode)jsonNode3, DefaultBpmIdentity.class);
                    identityList.add(identity);
                }
            }
            if (taskCmd.getTransitVars("bpm_next_node_users_") != null) {
                identityList = (List)taskCmd.getTransitVars("bpm_next_node_users_");
            }
            if (nodeUsers != null && nodeUsers.containsKey(nodeId)) {
                identityList = (List)nodeUsers.get(nodeId);
            }
            if (BeanUtils.isEmpty(identityList)) {
                identityList = delegateTask.getExecutors();
            }
            if (BeanUtils.isEmpty(identityList)) {
                Map<String, List<BpmIdentity>> identityMap = taskCmd.getBpmIdentities();
                identityList = identityMap.get(nodeId);
            }
            if (BeanUtils.isEmpty((Object)(instance = (BpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
                instance = (BpmProcessInstance)this.instanceManager.get((Serializable)((Object)instId));
            }
            if (!(isAllowEmptyIdentity = BpmUtil.isAllowEmptyIdentity(instance, nodeId)) && BeanUtils.isEmpty(identityList)) {
                NoExecutorModel noExcutor = NoExecutorModel.getNoExecutorModel(delegateTask.getId(), delegateTask.getProcessInstanceId(), subject, delegateTask.getTaskDefinitionKey(), delegateTask.getName(), delegateTask.getBpmnDefId());
                BpmUtil.publishNoExecutorEvent(noExcutor);
                String msg = "\u3010" + delegateTask.getName() + "\u3011\u6ca1\u6709\u4efb\u52a1\u6267\u884c\u4eba";
                ThreadMsgUtil.addMapMsg((String)"msg_flow_error", (String)msg);
                throw new NoTaskUserException(msg);
            }
            this.addOpinion(delegateTask, identityList);
            this.bpmTaskManager.assignUser(delegateTask, identityList);
            this.bpmProStatusManager.createOrUpd(instId, delegateTask.getBpmnDefId(), nodeId, delegateTask.getName(), NodeStatus.PENDING);
            this.bpmExeStackManager.pushStack(delegateTask);
            this.setDueTime(delegateTask, identityList, instance);
            NodeNotifyModel model = new NodeNotifyModel(instance.getProcDefId(), nodeId);
            model.setTask(delegateTask);
            model.setTiming("create");
            NodeNotifyEvent eve = new NodeNotifyEvent(model);
            AppUtil.publishEvent((ApplicationEvent)eve);
            if (!OpinionStatus.REJECT.getKey().equals(taskCmd.getActionName()) || !"direct".equals(taskCmd.getTransitVars("backHandMode")) && BeanUtils.isNotEmpty((Object)instance)) {
                BpmProcessInstanceManager instanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
                instanceManager.delVarByInstIdAndName(instance.getBpmnInstId(), "bpm_node_users_" + nodeId, "bpm_destination_" + nodeId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void setDueTime(BpmDelegateTask delegateTask, List<BpmIdentity> identityList, BpmProcessInstance instance) throws Exception {
        BpmIdentity bpmIdentity;
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(delegateTask.getId());
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            return;
        }
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(bpmTask.getProcDefId());
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        NodeProperties nodeProperties = bpmNodeDef.getLocalProperties();
        LocalDateTime dueTime = null;
        String userId = "";
        String userName = "";
        int dueTimeMin = 0;
        String dateTpye = "";
        if (nodeProperties.getDueTime() != 0) {
            dueTimeMin = nodeProperties.getDueTime();
            dateTpye = nodeProperties.getDateType();
        } else {
            dueTimeMin = defExt.getExtProperties().getDueTime();
            dateTpye = defExt.getExtProperties().getDateType();
        }
        if (dueTimeMin == 0) {
            return;
        }
        if ("caltime".equals(dateTpye)) {
            dueTime = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)dueTimeMin, (long)TimeUtil.getTimeMillis((LocalDateTime)bpmTask.getCreateTime())));
        } else if (BeanUtils.isNotEmpty(identityList) && "user".equals((bpmIdentity = identityList.get(0)).getType())) {
            userId = bpmIdentity.getId();
            userName = bpmIdentity.getName();
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", identityList.get(0).getId());
            if (BeanUtils.isNotEmpty((Object)bpmTask.getCreateTime())) {
                params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTask.getCreateTime()));
            }
            params.put("time", dueTimeMin);
            String dueTimeStr = this.systemConfigFeignService.getEndTimeByUser(params);
            dueTime = DateFormatUtil.parse((String)dueTimeStr);
        }
        BpmTaskDueTime bpmTaskDueTime = new BpmTaskDueTime();
        bpmTaskDueTime.setId(UniqueIdUtil.getSuid());
        bpmTaskDueTime.setDateType(dateTpye);
        bpmTaskDueTime.setDueTime(dueTimeMin);
        bpmTaskDueTime.setRemainingTime(dueTimeMin);
        bpmTaskDueTime.setExpirationDate(dueTime);
        bpmTaskDueTime.setInstId(bpmTask.getProcInstId());
        bpmTaskDueTime.setTaskId(bpmTask.getTaskId());
        bpmTaskDueTime.setStartTime(bpmTask.getCreateTime());
        bpmTaskDueTime.setUserId(userId);
        bpmTaskDueTime.setUserName(userName);
        bpmTaskDueTime.setIsNew((short)1);
        bpmTaskDueTime.setStatus((short)0);
        this.bpmTaskDueTimeManager.create((Model)bpmTaskDueTime);
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            ContextThreadUtil.addTask(bpmTask);
        }
    }

    private void addOpinion(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) {
        String ids = "";
        String names = "";
        if (BeanUtils.isNotEmpty(identityList)) {
            ids = BpmCheckOpinionUtil.getIdentityIds(identityList);
            names = BpmCheckOpinionUtil.getIdentityNames(identityList);
        }
        String instId = (String)delegateTask.getVariable("instanceId_");
        DefaultBpmCheckOpinion bpmCheckOpinion = BpmCheckOpinionUtil.buildBpmCheckOpinion(delegateTask, instId);
        bpmCheckOpinion.setQualfieds(ids);
        bpmCheckOpinion.setQualfiedNames(names);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        this.setSignType(bpmCheckOpinion, cmd);
        if (cmd instanceof TaskFinishCmd) {
            bpmCheckOpinion.setParentTaskId(((TaskFinishCmd)cmd).getTaskId());
        }
        this.bpmCheckOpinionManager.create((Model)bpmCheckOpinion);
    }

    private void setSignType(DefaultBpmCheckOpinion bpmCheckOpinion, ActionCmd cmd) {
        Object opinionSignType = cmd.getTransitVars("opinion_sign_type");
        if (BeanUtils.isNotEmpty((Object)opinionSignType)) {
            bpmCheckOpinion.setSignType("BeforeSign");
        } else {
            String id;
            DefaultBpmCheckOpinion defaultBpmCheckOpinion;
            Map<String, Object> variables = cmd.getVariables();
            if (variables.containsKey("pre_bpm_check_opinion_id") && BeanUtils.isNotEmpty((Object)variables.get("pre_bpm_check_opinion_id")) && BeanUtils.isNotEmpty((Object)(defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)(id = String.valueOf(variables.get("pre_bpm_check_opinion_id"))))))) && StringUtil.isNotEmpty((String)defaultBpmCheckOpinion.getSignType())) {
                bpmCheckOpinion.setSignType("AfterSign");
            }
        }
    }
}

