package com.artfess.base.jaxb;

import com.artfess.base.util.StringUtil;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;

/**
 * @author zjq
 */
public class LocalDateTimeAdapter extends XmlAdapter<String, LocalDateTime> {
    @Override
    public LocalDateTime unmarshal(String v) throws Exception {
        if (StringUtil.isNotEmpty(v)) {
            return LocalDateTime.parse(v);
        }
        return null;
    }

    @Override
    public String marshal(LocalDateTime v) throws Exception {
        if (v != null) {
            return v.toString();
        }
        return null;
    }
}
