package com.artfess.base.aop;


import com.artfess.base.util.ThreadLocalCleanUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

/**
 * 异步线程清理线程变量切面
 *
 * @company 阿特菲斯信息技术有限公司
 * @author zhangxw
 * @email zhangxw@jee-soft.cn
 * @date 2020年11月6日
 */
@Aspect
@Component
public class AsyncThreadCleanAspect{
	
	@Around("@annotation(com.artfess.base.annotation.AsyncThreadClean)")
	public Object threadLocalClean(ProceedingJoinPoint joinPoint) throws Throwable{
		ThreadLocalCleanUtil.cleanAll();
		return joinPoint.proceed();
	}
}
