import * as echarts from 'echarts'
import cq from '@/assets/js/cq.js'
import main9 from '@/assets/js/main9.js'
import fakeData from '@/views/BigScreen/js/fakeData_district.js'
import apiList from '@/api/bigScreen/districView.js'
const emphasisColor = {
    A: '#2ce5c4',
    B: '#4CA9FF',
    C: '#F9F953',
    D: '#EFB569',
    E: '#E42020',
    N: '#aaf15e',
}
export default {
    name: 'mapTargetMixin',
    data() {
        return {
            loadingColor: 'rgba(6, 46, 106, 0.4)',
            loading: false,
            myChartCQ: null,
            optionCQ: null,
            myChartMain: null,
            optionMain: null,
            levelDataA: [],
            levelDataB: [],
            levelDataC: [],
            levelDataD: [],
            levelDataE: [],
            areaCode: [
                {
                    code: 500120,
                    name: '璧山区',
                },
                {
                    code: 500155,
                    name: '梁平区',
                },
                {
                    code: 500241,
                    name: '秀山县',
                },
                {
                    code: 500231,
                    name: '垫江县',
                },
                {
                    code: 500109,
                    name: '北碚区',
                },
                {
                    code: 500229,
                    name: '城口县',
                },
                {
                    code: 500230,
                    name: '丰都县',
                },
                {
                    code: 500113,
                    name: '巴南区',
                },
                {
                    code: 500152,
                    name: '潼南区',
                },
                {
                    code: 500235,
                    name: '云阳县',
                },
                {
                    code: 500233,
                    name: '忠县',
                },
                {
                    code: 500238,
                    name: '巫溪县',
                },
                {
                    code: 500108,
                    name: '南岸区',
                },
                {
                    code: 500107,
                    name: '九龙坡区',
                },
                {
                    code: 500112,
                    name: '渝北区',
                },
                {
                    code: 500116,
                    name: '江津区',
                },
                {
                    code: 500119,
                    name: '南川区',
                },
                {
                    code: 500154,
                    name: '开州区',
                },
                {
                    code: 500118,
                    name: '永川区',
                },
                {
                    code: 500110,
                    name: '綦江区',
                },
                {
                    code: 500243,
                    name: '彭水县',
                },
                {
                    code: 500106,
                    name: '沙坪坝区',
                },
                {
                    code: 500153,
                    name: '荣昌区',
                },
                {
                    code: 500156,
                    name: '武隆区',
                },
                {
                    code: 500236,
                    name: '奉节县',
                },
                {
                    code: 500102,
                    name: '涪陵区',
                },
                {
                    code: 500240,
                    name: '石柱县',
                },
                {
                    code: 500117,
                    name: '合川区',
                },
                {
                    code: 500115,
                    name: '长寿区',
                },
                {
                    code: 500103,
                    name: '渝中区',
                },
                {
                    code: 500111,
                    name: '大足区',
                },
                {
                    code: 500237,
                    name: '巫山县',
                },
                {
                    code: 500101,
                    name: '万州区',
                },
                {
                    code: 500114,
                    name: '黔江区',
                },
                {
                    code: 500104,
                    name: '大渡口区',
                },
                {
                    code: 500105,
                    name: '江北区',
                },
                {
                    code: 500242,
                    name: '酉阳县',
                },
                {
                    code: 500151,
                    name: '铜梁区',
                },
                {
                    code: 500200,
                    name: '两江新区',
                },
                {
                    code: 500300,
                    name: '高新区',
                },
                {
                    code: 500222,
                    name: '万盛经开区',
                },
            ],
            tableData: [],
            tableColumn: [],
            ljxqGrade: '',
            gxqGrade: '',
            lsFd: {},
            typeNum: '',
            typeGrade: '',
            year: '',
            quarter: '',
            isSub: true,
            meanObj: {},
        }
    },
    watch: {
        isSub: {
            handler(nv, ov) {
                if (nv) {
                    this.$nextTick(() => {
                        this.initMapMain()
                        this.initMapCQ()
                    })
                }

            },
            immediate: true
        }
    },
    mounted() {
        this.$bus.$on('changeDate', () => {
            this.$nextTick(() => {
                this.getAxiosData()
            })
        })
    },
    methods: {
        loadComplete() {
            this.$nextTick(() => {
                this.$emit('mounted')
            })
        },
        // 设置是否分档
        setIsSub() {
            let { year, quarter } = JSON.parse(sessionStorage.getItem('searchDate'))
            this.quarter = quarter
            if (year === 2023 && (quarter === 1 || quarter === 5)) {
                this.isSub = false
            } else {
                this.isSub = true
            }
            this.setLsFd()
        },
        // 设置档位
        setLsFd() {
            let { year, quarter } = JSON.parse(sessionStorage.getItem('searchDate'))
            this.quarter = quarter
            this.year = year
            if (year === 2023 && quarter === 1 && this.isSub) {
                this.lsFd = { A: true, B: true, C: true, D: true, E: true }
            } else if (!this.isSub) {
                this.lsFd = { A: true, B: false, C: false, D: false }
            } else {
                this.lsFd = { A: true, B: true, C: true, D: true }
            }
        },
        handleDetail(comp, unitName, type) {
            this.$router.push({
                path: '/DetailComponent',
                name: 'DetailComponent',
                query: {
                    unitName,
                    comp,
                    type,
                    numType: 'nationalNum'
                },
            })
        },
        initData() {
            // this.loading = true
            let searchDate = sessionStorage.getItem('searchDate')
            searchDate = JSON.parse(searchDate)
            let data = this.qs.stringify({
                year: searchDate.year,
                quarter: searchDate.quarter,
            })
            this.levelDataA = []
            this.levelDataB = []
            this.levelDataC = []
            this.levelDataD = []
            this.levelDataE = []
            setTimeout(() => {
                let mapData = JSON.parse(sessionStorage.getItem('mapData'))
                this.meanObj = mapData
                this.formatSortData(mapData.statementDetailVo)
                if (!this.isSub) {
                    let arr = JSON.parse(JSON.stringify(this.tableData[0]))
                    this.$bus.$emit('exportExcel', arr)
                } else {
                    this.$bus.$emit('exportExcel', mapData.statementDetailVo)
                }
            }, 500)
            // console.log(mapData, 'mapData');
            // apiList.statementDetail(data, (res) => {
            //     if (res) {
            //         this.meanObj = res
            //         this.formatSortData(res.statementDetailVo)
            //         if (!this.isSub) {
            //             let arr = JSON.parse(JSON.stringify(this.tableData[0]))
            //             this.$bus.$emit('exportExcel', arr)
            //         } else {
            //             this.$bus.$emit('exportExcel', res.statementDetailVo)
            //         }
            //     }
            // })
        },
        getAxiosData() {
            let searchDate = sessionStorage.getItem('searchDate')
            searchDate = JSON.parse(searchDate)
            let data = this.qs.stringify({
                year: searchDate.year,
                quarter: searchDate.quarter,
            })
            apiList.statementDetail(data, (res) => {
                if (res) {
                    sessionStorage.setItem('mapData', JSON.stringify(res))
                    this.$forceUpdate()
                }
            })
        },
        formatSortData(data) {
            let { typeNum, typeGrade } = this
            let { year, quarter } = JSON.parse(sessionStorage.getItem('searchDate'))
            data.sort((a, b) => {
                return a[typeNum] - b[typeNum]
            })

            data.forEach((item) => {
                if (item[typeGrade] == 'A') {
                    this.levelDataA.unshift(item)
                }
                if (item[typeGrade] == 'B') {
                    this.levelDataB.unshift(item)
                }
                if (item[typeGrade] == 'C') {
                    this.levelDataC.unshift(item)
                }
                if (item[typeGrade] == 'D') {
                    this.levelDataD.unshift(item)
                }
                if (item[typeGrade] == 'E') {
                    this.levelDataE.unshift(item)
                }
            })

            if (quarter !== 5) {
                let ljxqGrade = data.filter(item => item.unitCode === '500191000000')
                let gxqGrade = data.filter(item => item.unitCode === '500193000000')
                this.ljxqGrade = ljxqGrade[0][typeGrade]
                this.gxqGrade = gxqGrade[0][typeGrade]
            } else {
                this.ljxqGrade = ''
                this.gxqGrade = ''
            }

            this.isSub && this.myChartMain && this.handleMapArea(data, 'composite')
            // 根据区县排序
            let Aarr = this.levelDataA.sort((a, b) => a.orderNo - b.orderNo)
            let Barr = this.levelDataB.sort((a, b) => a.orderNo - b.orderNo)
            let Carr = this.levelDataC.sort((a, b) => a.orderNo - b.orderNo)
            let Darr = this.levelDataD.sort((a, b) => a.orderNo - b.orderNo)
            let Earr = this.levelDataE.sort((a, b) => a.orderNo - b.orderNo)
            // 根据项目个数排序
            let Aarr1 = Aarr.sort((a, b) => b[typeNum] - a[typeNum])
            let Barr1 = Barr.sort((a, b) => b[typeNum] - a[typeNum])
            let Carr1 = Carr.sort((a, b) => b[typeNum] - a[typeNum])
            let Darr1 = Darr.sort((a, b) => b[typeNum] - a[typeNum])
            let Earr1 = Earr.sort((a, b) => b[typeNum] - a[typeNum])
            if (!this.isSub) {
                // 只晾晒不分档
                if (!Aarr1.length) {
                    data.sort((a, b) => a.orderNo - b.orderNo)
                    data.sort((a, b) => b[typeNum] - a[typeNum])
                    Aarr1 = data
                } else {
                    Aarr1 = [...Aarr1, ...Barr1, ...Carr1, ...Darr1, ...Earr1]
                }
                let AarrOne = Aarr1.splice(0, 14)
                let AarrTwo = Aarr1.splice(0, 14)
                let AarrThree = Aarr1
                Aarr1 = [...AarrThree, ...AarrTwo, ...AarrOne]
                this.tableData = [Aarr1, [], [], [], []]
            } else {
                // 晾晒并分档
                this.tableData = [Aarr1, Barr1, Carr1, Darr1, Earr1]
            }
        },
        handleMapArea(markData, key) {
            this.optionCQ.series[0].data = this.convertData(
                cq.features,
                markData,
                key
            )
            this.optionMain.series[0].data = this.convertData(
                main9.features,
                markData,
                key,
                true
            )

            this.myChartCQ.setOption(this.optionCQ)
            this.myChartMain.setOption(this.optionMain)
            this.loading = false
        },
        convertData(data, mapData, key, showTitle) {
            let { year, quarter } = JSON.parse(sessionStorage.getItem('searchDate'))
            if (quarter === 5) {
                mapData.forEach(item => {
                    item.allGrade = ''
                    item.nationalProjectGrade = ''
                    item.nationwideGrade = ''
                    item.nationalPassGrade = ''
                    item.workableNationalAddGrade = ''
                    item.cityGrade = ''
                })
            }

            let res = []
            for (let i = 0; i < data.length; i++) {
                let obj = data[i].properties
                let color = '#081c47'
                let find = mapData.find((item) => item.unitCode == obj.code)

                let regionSnKey = 'allSn'
                if (key == 'composite') {
                    regionSnKey = this.typeGrade
                }
                if (key == 'workable') {
                    regionSnKey = 'workableAllSn'
                }
                if (key == 'brand') {
                    regionSnKey = 'brandAllSn'
                }
                if (key == 'satisfaction') {
                    regionSnKey = 'satisfiedAllSn'
                }
                if (find && key !== 'risk') {
                    // 绿色：#20A367 蓝色：#3877B2 黄色：#E3C428 橙色：#E49317 红色：#B04332
                    if (find[regionSnKey] == 'A') {
                        // color = '#398C8F'
                        color = '#20A367'
                    } else if (find[regionSnKey] == 'B') {
                        // color = '#1970C1'
                        color = '#3877B2'
                    } else if (find[regionSnKey] == 'C') {
                        // color = '#A3A355'
                        color = '#E3C428'
                    } else if (find[regionSnKey] == 'D') {
                        // color = '#B0825C'
                        color = '#E49317'
                    } else if (find[regionSnKey] == 'E') {
                        // color = '#9B4E55'
                        color = '#B04332'
                    }
                }
                let show = true
                let offset = [0, 0]
                if (
                    [
                        '渝中区',
                        '大渡口区',
                        '江北区',
                        '沙坪坝区',
                        '九龙坡区',
                        '南岸区',
                        '北碚区',
                        '渝北区',
                        '巴南区',
                        '两江新区',
                        '高新区',
                    ].includes(obj.name)
                ) {
                    show = false
                }
                if (['沙坪坝区'].includes(obj.name)) {
                    offset = [-10, 0]
                }
                if (['九龙坡区'].includes(obj.name)) {
                    offset = [-10, -10]
                }
                if (['大渡口区'].includes(obj.name)) {
                    offset = [0, 5]
                }
                if (['江北区'].includes(obj.name)) {
                    offset = [10, 0]
                }
                if (['南岸区'].includes(obj.name)) {
                    offset = [10, 6]
                }
                if (['綦江区'].includes(obj.name)) {
                    offset = [0, 20]
                }
                if (showTitle != undefined) {
                    show = showTitle
                }
                if (obj.name == '两江新区' || obj.name == '高新区') {
                    show = false
                }
                res.push({
                    name: obj.name,
                    value: find ? find['unitCode'] : 0,
                    itemStyle: {
                        color: color,
                        areaColor: color,
                        label: {
                            show,
                        },
                    },
                    label: {
                        normal: {
                            show,
                            offset, //是否对文字进行偏移。默认不偏移。例如：[30, 40] 表示文字在横向上偏移 30，纵向上偏移 40。
                            position: 'inside', //标签的位置。// 绝对的像素值[10, 10]
                            color: '#fff',
                            fontSize: 12,
                        },
                    },
                    emphasis: {
                        // disabled: true,
                        itemStyle: {
                            areaColor:
                                emphasisColor[find ? find[regionSnKey] : 'N'],
                        },
                        label: {
                            color: '#ffffff',
                        },
                    },
                })
            }
            return res
        },
        initMapCQ() {
            let dom = document.getElementById(this.CQId)
            if (dom) {
                let width = getComputedStyle(dom)
                    .getPropertyValue('width')
                    .replace('px', '')
                let height = getComputedStyle(dom)
                    .getPropertyValue('height')
                    .replace('px', '')
                width = parseInt(width, 10)
                height = parseInt(height, 10)
                this.myChartCQ = dom && echarts.init(dom, null, {
                    renderer: 'svg',
                    width,
                    height,
                })
                // 注册 echarts 地图

                echarts.registerMap('cq', cq)
                var markPointData = []
                let map = 'cq',
                    top = '40%',
                    left = '-15%',
                    zoom = 1.2,
                    aspectScale = 1,
                    center = [106.5049, 29], // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                    layoutCenter = ['50%', '50%']
                this.optionCQ = {
                    series: [
                        {
                            name: '重庆',
                            type: 'map', //配置显示方式为用户自定义
                            map,
                            zoom, // 地图比例
                            zlevel: 100,
                            center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                            aspectScale,
                            // roam: true,
                            scaleLimit: {
                                min: 0.6,
                                max: 4,
                            },
                            itemStyle: {
                                normal: {
                                    borderWidth: 1, //设置外层边框
                                    borderColor: '#2ddcfd',
                                },
                            },
                            emphasis: {
                                itemStyle: {
                                    areaColor: 'yellow',
                                },
                            },
                            top,
                            left,
                            data: this.convertData(
                                cq.features,
                                fakeData.btnkey1,
                                'risk'
                            ),
                        },
                    ],
                }
                this.myChartCQ.setOption(this.optionCQ)
                if (this.isClick) {
                    this.myChartCQ.on('click', (params) => {
                        let code = params.value
                        if (!code) {
                            code = this.getAreaCode(params.name, cq)
                        }
                        this.$router.push({
                            path: '/DistrictReformSubView',
                            query: {
                                name: params.name,
                                code: code,
                            },
                        })
                        let tooltip =
                            document.getElementsByClassName('data-tooltip')
                        Array.from(tooltip).forEach((item) => {
                            item.remove()
                        })
                    })
                }
            }
        },
        initMapMain() {
            let dom = document.getElementById(this.main9Id)
            if (dom) {
                this.myChartMain = echarts.init(
                    dom,
                    null,
                    {
                        renderer: 'svg',
                    }
                )
                // 注册 echarts 地图
                echarts.registerMap('main9', main9)
                var markPointData = []
                let top = 28, //
                    left = 25,
                    zoom = 1.2,
                    map = 'main9',
                    aspectScale = 1,
                    layoutCenter = ['50%', '50%'],
                    center = [106.204962, 29.533155] // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                this.optionMain = {
                    geo: [
                        {
                            map,
                            zoom,
                            zlevel: 0,
                            aspectScale,
                            itemStyle: {
                                normal: {
                                    borderWidth: 0,
                                },
                            },
                            emphasis: {
                                itemStyle: {
                                    areaColor: 'yellow',
                                },
                            },
                            tooltip: {
                                show: false,
                            },
                            top,
                            left,
                            layoutCenter,
                        },
                    ],
                    series: [
                        {
                            name: '重庆主城',
                            type: 'map',
                            map,
                            zoom, // 地图比例
                            zlevel: 100,
                            // center, // 地图中心位置， 此处的纬度与下面的center相差1度是形成阴影的距离，可自己随意调整
                            aspectScale,
                            itemStyle: {
                                normal: {
                                    borderWidth: 1, //设置外层边框
                                    borderColor: 'white',
                                },
                            },
                            emphasis: {
                                // disabled: true,
                                itemStyle: {
                                    areaColor: 'yellow',
                                },
                            },
                            top,
                            left,
                            data: this.convertData(
                                main9.features,
                                fakeData.btnkey1,
                                'risk',
                                true
                            ),
                        },
                    ],
                }
                this.myChartMain.setOption(this.optionMain)
                if (this.isClick) {
                    this.myChartMain.on('click', (params) => {
                        let code = params.value
                        if (!code) {
                            code = this.getAreaCode(params.name, main9)
                        }
                        this.$router.push({
                            path: '/DistrictReformSubView',
                            query: {
                                name: params.name,
                                code: code,
                            },
                        })
                        let tooltip = document.querySelectorAll('.data-tooltip')
                        Array.from(tooltip).forEach((item) => {
                            item.remove()
                        })
                    })
                }
            }
        },
        resize(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                let dom = document.getElementById(this.CQId)
                if (!dom) return
                let width = getComputedStyle(dom)
                    .getPropertyValue('width')
                    .replace('px', '')
                let height = getComputedStyle(dom)
                    .getPropertyValue('height')
                    .replace('px', '')
                width = parseInt(width, 10)
                height = parseInt(height, 10)
                this.myChartCQ.resize({
                    width: width,
                    height: height,
                })
                this.myChartMain.resize()
            }, delay || 0)
        },
        goToSub(type) {
            let data = {
                ljxq: {
                    name: '两江新区',
                    code: '500191000000',
                },
                gxq: {
                    name: '高新区',
                    code: '500193000000',
                },
            }
            this.$router.push({
                path: '/DistrictReformSubView',
                query: {
                    name: data[type].name,
                    code: data[type].code,
                },
            })
        },
    }
}