export default {
    name: 'bigScreenMixin',
    data() {
        return {
            scale: 1,
            height: 1080,
            width: 1920,
        }
    },
    mounted() {
        this.setScale();
        window.addEventListener("resize", this.setScale);
        this.$store.dispatch('menu/actionFrontMenus').then((data) => {
            // 过滤出大屏菜单
            let Allmenu = []
            Allmenu = this.frontMenus.filter(
                (item) => item.alias === 'bigScreen'
            )[0].children
            Allmenu.forEach(item => {
                if (item.alias === 'MajorProjectsViewTest') {
                    item.alias = 'MajorProjectsView'
                }
            })
            this.currentMenu = Allmenu.filter(
                (item) => item.alias == this.currentKey
            )[0]
            this.menuData = Allmenu.filter(
                (item) => item.alias !== this.currentKey
            )
            this.workPlatMenu = this.frontMenus.filter(
                (item) => item.alias === 'normal'
            )
            this.showWorkPlat = this.workPlatMenu.length ? true : false
        })
    },

    methods: {
        setScale() {
            // 获取到缩放比例，设置它
            this.scale = this.getScale();
            if (this.$refs.ScaleBox) {
                // console.log(this.$refs.ScaleBox.style)
                this.$refs.ScaleBox.style.setProperty("--scale", this.scale);
            }
        },
        getScale() {
            // 固定好16：9的宽高比，计算出最合适的缩放比
            const { width, height } = this;
            const wh = window.innerHeight / height;
            const ww = window.innerWidth / width;
            return ww < wh ? ww : wh;
        },
        getWindowSize() {
            this.$nextTick(() => {
                console.log(this.$refs.bigScreen)
                // this.$refs.bigScreen.clientHeight
            })

        },
        findFirstChild(meuns) {
            if (meuns[0].children && meuns[0].children.length) {
                return this.findFirstChild(meuns[0].children)
            } else {
                return meuns[0].alias
            }
        },
        // 跳转工作台
        toWorkbench() {
            if (this.workPlatMenu.length !== 0) {
                let alias = this.findFirstChild(this.workPlatMenu)
                this.$router.push({
                    path: `/platLayout/${alias}`,
                })
                sessionStorage.removeItem("searchDate")
            }
        },
        logout() {
            this.$store.dispatch('menu/clearMenus')
            this.$store.dispatch('user/clearUser')
            this.$store.dispatch('menu/setCopyMenus', []) //菜单
            let loginRouthPath =
                localStorage.getItem(
                    this.$store.state.login.currentUser.account +
                    'loginRoutePath'
                ) || '/login'
            this.$store.dispatch('login/logoutAndCleanUp').then(() => {
                switch (window.ssoConfig.mode) {
                    case 'cas':
                    case 'oauth':
                        window.sessionStorage.removeItem('currentUser')
                        window.location.href =
                            window.ssoConfig.logout +
                            '?service=' +
                            window.location.href.split('?')[0]
                        break
                    default:
                        this.$router.push({
                            path: loginRouthPath,
                        })
                        break
                }
            })
        },

    }
}