import req from '@/request.js'
const portal = window.context.portal
export default {
    // 查询试点项目录入列表
    getPilotprojectList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/query`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 录入试点项目
    addPolotProject(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/saveQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 修改录入试点项目信息
    updatePoltproject(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/updateQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 判断下发文号是否存在
    docNoWhether(docNo, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/ifExist?docNo=${docNo}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县领导审核查询数据

    getDistrictAudits(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/disQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 主管部门审核列表查询
    getAuthorities(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/pilQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 根据id改变状态
    // updateStatusById(data, cb) {
    //   let {status, id} = data
    //   req
    //     .post(
    //       portal +
    //         `/biz/bizReformPilotManagement/v1/updateById?status=${status}&id=${id}`
    //     )
    //     .then(res => {
    //       cb(res.data)
    //     })
    // },
    updateStatusById(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/updateById`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 携带驳回原因
    // 修改录入试点项目信息
    // updatePoltproject(data, cb) {
    //   req
    //     .post(portal + `/biz/bizReformPilotManagement/v1/updateQuery`, data)
    //     .then(res => {
    //       cb(res.data)
    //     })
    // },

    // 根据id删除数据，可批量删除
    deletePilotProject(ids, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/removeQuery/${ids}`)
            .then(res => {
                cb(res.data)
            })
    },

    // 查询项目推进录入列表
    getDistrictInputList(data, isAffirm, cb) {
        req
            .post(
                portal +
                `/biz/bizReformPilotManagement/v1/invPush?isAffirm=${isAffirm}`,
                data
            )
            .then(res => {
                cb(res.data)
            })
    },

    // 最后一个页面
    getromList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/munInfo`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 区县推荐录入 录入更新
    inputUpdate(data, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/saveQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 修改录入更新
    modifyEntry(data, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/updateQuery`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据主表id查询推进表信息
    advanceRecordsById(data, cb) {
        let { id, unitId } = data
        req
            .post(
                portal +
                `/biz/bizReformPilotManagement/v1/findModelHis?id=${id}&unitId=${unitId}`
            )
            .then(res => {
                cb(res.data)
            })
    },
    // 根据主表id查询推进表信息  (已删除的)
    advanceDeleteRecordsById(data, cb) {
        let { id, unitId } = data
        req
            .post(
                portal +
                `/biz/bizPilotAdvanceRecord/v1/queryDeleteById?pilotId=${id}&unitId=${unitId}`
            )
            .then(res => {
                cb(res.data)
            })
    },
    // 推进录入领导审核列表
    getDpvList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/invAudit`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县录入上报
    districtAuditsById(data, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/updateById`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县确认
    getRpmList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/pilAudit`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 市改革办审核列表

    getRpcList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/munAudit`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 根据项目id判断区县是否存在还未审核完成的推进记录
    doneOrNot(id, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/passById/${id}`)
            .then(res => {
                cb(res.data)
            })
    },

    // 根据id查询试点项目详情
    getFindById(id, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/findById/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id查询已删除试点项目详情
    getDeleteById(id, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryDeleteById/${id}`)
            .then(res => {
                cb(res.data)
            })
    },


    // 查询项目审核列表
    getpilotVerifyList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/querySh`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 查询区县录入列表
    getResultList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryList`, data)
            .then(res => {
                cb(res.data)
            })
    },
    getQxtjsh(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListSh`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县推进录入
    saveResult(data, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/saveAll`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id获取推进录入信息
    getResultById(id, cb) {
        req
            .post(portal + `/biz/bizPilotAdvanceRecord/v1/findById/${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 查询附件
    getIds(data, cb) {
        req.post(portal + `/file/v1/query`, data).then(res => {
            cb(res.data)
        })
    },

    // 查询区县审核和区县确认列表
    auditsConfirmList(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListSh`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 市委审核确认列表
    getMunicipalConfirm(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListLast`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 市改革办审核分页查询搜索
    getShiggb(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListLast`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 主管单位审核、区县审核搜索
    getZgAndQx(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListSh`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县推荐录入搜索
    getQxlr(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryList`, data)
            .then(res => {
                cb(res.data)
            })
    },
    getListZgSh(data, cb) {
        req
            .post(portal + `/biz/bizReformPilotManagement/v1/queryListZgSh`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 试点主管部门删除
    rpvDeleteById(id, isAffirm, cb) {
        req
            .post(
                portal + `/biz/bizReformPilotManagement/v1/auditRemoveInfo?ids=${id}&isAffirm=${isAffirm}`
            )
            .then(res => {
                cb(res.data)
            })
    },

    // 核准分发时判断是否可撤销
    isQuash(id, cb) {
        req
            .post(
                portal + `/biz/bizReformPilotManagement/v1/inputRevInfo?pid=${id}`
            )
            .then(res => {
                cb(res.data)
            })
    },


    //市级试点项目模块
    munCheckDocNo(data, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/isSameExists?docNo=${data.docNo}&id=${data.id}`).then(res => {
            cb(res.data)
        })
    },
    // 分页查询列表1、2、4 /fill/bizReformPilotCityManagement/v1/queryPage
    getTableData(data, isAffirm, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/queryPage?isAffirm=${isAffirm}`, data).then(res => {
            cb(res.data)
        })
    },
    // 删除 
    deleteMunPlit(ids, isAffirm, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/deleteInfo?ids=${ids}&isAffirm=${isAffirm}`).then(res => {
            cb(res.data)
        })
    },
    // 新增或修改
    saveOrUpdate(data, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/saveOrUpdateInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询详情
    // 根据推进id查询推进信息及成果信息
    getRecordAndResults(id, cb) {
        req.post(portal + `/fill/bizPilotAdvanceCityRecord/v1/findByHistory/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 修改审核状态 
    updateMunStatus(data, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/updateByStatus`, data).then(res => {
            cb(res.data)
        })
    },
    // 专项小组分页查询审核数据
    groupTableData(data, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/queryGroupPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id删除试点成果 /fill/bizPilotAdvanceCityResult/v1/{id}
    deleteResultById(id, cb) {
        req.remove(portal + `/fill/bizPilotAdvanceCityResult/v1/${id}`).then(res => {
            cb(res.data)
        })
    },

    // 专项小组查询区县试点项目信息
    getPilotBasicInfo(data, code, cb) {
        req.post(portal + `/biz/bizReformPilotManagement/v1/queryGroup?code=${code}`, data).then(res => {
            cb(res.data)
        })
    },

    // 区县 --- 验收时间修改
    updateAcceptanceTime(data, cb) {
        req.post(portal + `/biz/bizReformPilotManagement/v1/updateIterateInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 查询区县验收时间审核列表
    getAcceptanceTimeList(data, cb) {
        req.post(portal + `/fill/bizReformIteratePilotManagement/v1/query`, data).then(res => {
            cb(res.data)
        })
    },

    // 根据id查询实体
    getEntityById(id, cb) {
        req.get(portal + `/fill/bizReformIteratePilotManagement/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 验收时间审核 
    auditTime(data, cb) {
        req.post(portal + `/fill/bizReformIteratePilotManagement/v1/updateIterateStatus`, data).then(res => {
            cb(res.data)
        })
    },

    // 市级部门验收时间
    updateMunAcceptanceTime(data, cb) {
        req.post(portal + `/fill/bizReformPilotCityManagement/v1/updateIterateInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 试点查询接口  可查询已删除数据 (区县项目录入、审核、确认分发)
    ReformPilotQuery(isAffirm, data, cb) {
        req.post(portal + `/biz/bizReformPilotManagement/v1/queryInput?isAffirm=${isAffirm}`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据推进id判断区县当前季度是否更新并改革办已审核通过
    updateAndPass(id, cb) {
        req.post(portal + `/biz/bizPilotAdvanceRecord/v1/updateToQuarter/${id}`).then(res => {
            cb(res.data)
        })
    },

}