import req from '@/request.js'

const portal = window.context.portal
export default {
  // 分页查询
  getProject(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMunicipalReformSituation/v1/query`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 获取自动抓取数据
  getAutoDetail(data) {
    return new Promise((resolve, reject) => {
      req
        .get(portal + `/bizMunicipalReformSituation/v1/initForm`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 新增
  createdProject(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMunicipalReformSituation/v1/`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 根据id查询详情
  getDetailById(id, data) {
    return new Promise((resolve, reject) => {
      req
        .get(portal + `/bizMunicipalReformSituation/v1/${id}`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  //数据修改
  editData(data) {
    return new Promise((resolve, reject) => {
      req
        .put(portal + `/bizMunicipalReformSituation/v1/`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 列表数据删除
  deleteData(ids) {
    return new Promise((resolve, reject) => {
      req
        .remove(portal + `/bizMunicipalReformSituation/v1/?ids=${ids}`)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 市级推进录入分页查询
  propelGetData(data, isAffirm) {
    return new Promise((resolve, reject) => {
      req
        .post(
          portal +
            `/bizMunicipalReformSituation/v1/queryByPower?isAffirm=${isAffirm}`,
          data
        )
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },
  // 推进录入
  advanceEntry(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMunicipalReformSituationFill/v1/`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },
  // 修改
  advanceUpdate(data) {
    return new Promise((resolve, reject) => {
      req
        .put(portal + `/bizMunicipalReformSituationFill/v1/`, data)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },

  // 根据id查询详情
  getPropelDetail(id) {
    return new Promise((resolve, reject) => {
      req
        .get(portal + `/bizMunicipalReformSituationFill/v1/${id}`)
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  },
  // 撤回
  propelRevocation({id, status}) {
    return new Promise((resolve, reject) => {
      req
        .post(
          portal +
            `/bizMunicipalReformSituationFill/v1/updateByStatus?id=${id}&status=${status}`
        )
        .then(res => {
          resolve((res && res.data) || [])
        })
        .catch(err => {
          reject(err)
        })
    })
  }
}
