import req from '@/request.js'
const portal = window.context.portal
export default {
    // ---------市级成效--------------
    // 市级成效列表查询
    getCItyTableData(isAffirm, status, data, cb) {
        req
            .post(
                portal +
                `/fill/bizCityEffectDryingCompetition/v1/queryAudit?isAffirm=${isAffirm}&status=${status}`,
                data
            )
            .then(res => {
                cb(res.data)
            })
    },
    // 专项小组列表查询
    getGroupTableData(data, cb) {
        req
            .post(
                portal +
                `/fill/bizCityEffectDryingCompetition/v1/queryGroup`,
                data
            )
            .then(res => {
                cb(res.data)
            })
    },
    // 市级根据id查询详情
    getDetailById(id, cb) {
        req
            .post(portal + `/fill/bizCityEffectDryingCompetition/v1/queryById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 市级成效新增
    effectAdd(data, cb) {
        req
            .post(portal + `/fill/bizCityEffectDryingCompetition/v1/insert`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 市级成效修改
    effectUpdate(data, cb) {
        req
            .post(portal + `/fill/bizCityEffectDryingCompetition/v1/updateById`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 根据id修改审核状态
    updateSatusById(data,cb) {
        req
            .post(portal + `/fill/bizCityEffectDryingCompetition/v1/updateAuditStatus`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // ---------区县成效--------------
    // 区县成效列表查询
    getQXTableData(isAffirm, data, cb) {
        req
            .post(portal + `/bizEffectDryingCompetition/v1/queryAudit?isAffirm=${isAffirm}`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县根据id查询详情
    getQXDetailById(id, cb) {
        req
            .post(portal + `/bizEffectDryingCompetition/v1/queryById?id=${id}`)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县新增
    QXEffectAdd(data, cb) {
        req
            .post(portal + `/bizEffectDryingCompetition/v1/inserInfo`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 区县成效修改
    QXEffectUpdate(data, cb) {
        req
            .post(portal + `/bizEffectDryingCompetition/v1/updateById`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 加快实施一批项目查询
    getQuickenData(data, cb) {
        req
            .post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryByYear`, data)
            .then(res => {
                cb(res.data)
            })
    },
    // 两个一批项目查询
    getTwoBatchesData(data, cb) {
        req
            .post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/queryByYear`, data)
            .then(res => {
                cb(res.data)
            })
    },

    // 改革情况项目查询
    getReformSituation(data, cb) {
        req
            .post(portal + `/bizMunicipalReformSituation/v1/query`, data)
            .then(res => {
                cb(res.data)
            })
    }
}
