import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/operation/reductions/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
		req.put(portal + `/qf/operation/reductions/detail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//删除
	delDate(ids, cb) {
		req.remove(portal + `/qf/operation/reductions/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
		req.post(portal + `/qf/operation/reductions/query`, data).then(res => {
			cb(res.data)
		})
	},

	// id查询
	detailId(id, cb) {
		req.get(portal + `/qf/operation/reductions/` + id).then(rep => {
			cb(rep.data)
		})
	},
	//修改状态
	editStatus(data, cb) {
		req.put(portal + `/qf/operation/reductions/updateStatus`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
		req.post(portal + `/qf/operation/reductions/importExcel`, data).then(res => {
			cb(res.data)
		})
	},
	//导出
	export (data, cb) {
		req.post(portal + `/qf/operation/reductions/export`, data, 'blob').then(res => {
			cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
		req.post(portal + `/qf/operation/reductions/detail/batchSave`, data).then(res => {
			cb(res.data)
		})
	},
	//表格查询
	detailQuery(data, cb) {
		req.post(portal + `/qf/operation/reductions/detail/query`, data).then(res => {
			cb(res.data)
		})
	},
	//批量删除
	dleDetail(ids, cb) {
		req.remove(portal + `/qf/operation/reductions/detail/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},

}
