import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/subject/international/info/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
	    req.put(portal + `/qf/subject/international/info/`, data).then(res => {
	        cb(res.data)
	    })
	},
	//删除
	delDate(ids,cb){
		req.remove(portal+`/qf/subject/international/info/?ids=`+ids).then(res=>{
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
	  req.post(portal + `/qf/subject/international/info/query`, data).then(res => {
	    cb(res.data)
	  })
	},
	//排序
	sortData(data, cb) {
		req.post(portal + `/qf/subject/international/info/updateSequence`, data).then(res => {
			cb(res.data)
		})
	},
	// id查询
	detailId(id, cb) {
	    req.get(portal + `/qf/subject/international/info/` + id).then(rep => {
	        cb(rep.data)
	    })
	},
	//树
	treeData(data, cb) {
		req.post(portal + `/qf/subject/international/info/getTree`, data).then(res => {
			cb(res.data)
		})
	},
	//关联国际准则
	getSubject(data, cb) {
		req.post(portal + `/qf/subject/international/info/associatedSubject`, data).then(res => {
			cb(res.data)
		})
	},
	//移动科目
	moveTree(data, cb) {
		req.post(portal + `/qf/subject/international/info/move`, data).then(res => {
			cb(res.data)
		})
	},
}
