import req from '@/request.js'
import qs from 'qs'
const portal = window.context.portal
export default {
    // 指标分页查询
    getIndexTable(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationIndex/v1/query`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 新增指标
    addIndex(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationIndex/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 指标修改
    updateIndex(data) {
        return new Promise((resolve, reject) => {
            req
                .put(portal + `/bizMunicipalReformSituationIndex/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 批量启用或禁用指标
    addbatchUpdateIndex({ ids, isUse }) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal +
                    `/bizMunicipalReformSituationIndex/v1/bulkOperation?ids=${ids}&isUse=${isUse}`
                )
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 启用指标查询
    enableIndicator() {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizMunicipalReformSituationIndex/v1/enableIndex`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 指标填报
    indexDataEntry(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 指标修改
    indexDataUpdate(data) {
        return new Promise((resolve, reject) => {
            req
                .put(portal + `/bizMunicipalReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 填报数据分页查询
    getTableData(data, isAffirm) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal +
                    `/bizMunicipalReformSituationFill/v1/power/query?isAffirm=${isAffirm}`,
                    data
                )
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 专项小组分页查询
    getGroupTableData(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/group/query`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 根据id查询详情
    getDetailById(id) {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizMunicipalReformSituationFill/v1/${id}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 根据id修改审核状态
    getUpdateStatus(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/updateStatus`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 根据id删除数据
    getDeleteByIds(ids) {
        return new Promise((resolve, reject) => {
            req
                .remove(portal + `/bizMunicipalReformSituationFill/v1/?ids=${ids}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 检验当前部门本月是否已填报数据
    depIsEntry() {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizMunicipalReformSituationFill/v1/fillAuth`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    }
}
