import req from '@/request.js'
import qs from 'qs'
const portal = window.context.portal
export default {
    // 项目创建录入
    createdProject(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituation/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 项目创建录入分页查询
    getProject(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituation/v1/query`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 专项小组分页查询
    getGroupData(data,isAffirm) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituation/v1/queryByGroupPage?isAffirm=${isAffirm}`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 根据id查询详情
    getDetailById(id) {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizMunicipalReformSituation/v1/${id}`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    //   数据修改
    editData(data) {
        return new Promise((resolve, reject) => {
            req
                .put(portal + `/bizMunicipalReformSituation/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 列表数据删除
    deleteData(ids) {
        return new Promise((resolve, reject) => {
            req
                .remove(portal + `/bizMunicipalReformSituation/v1/?ids=${ids}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 创建项目下发
    sendData(id) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituation/v1/issued/${id}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 市级推进录入分页查询
    propelGetData(data, isAffirm) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituation/v1/queryByPower?isAffirm=${isAffirm}`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进录入
    advanceEntry(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 修改
    advanceUpdate(data) {
        return new Promise((resolve, reject) => {
            req
                .put(portal + `/bizMunicipalReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 根据id查询详情
    getPropelDetail(id) {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizMunicipalReformSituationFill/v1/${id}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 撤回
    propelRevocation({ id, status }) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/updateByStatus?id=${id}&status=${status}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 成效信息查询
    getEffectData(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/query/effect`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 试点信息查询
    getPilotData(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizMunicipalReformSituationFill/v1/query/cityPilot`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 区县推进录入
    // 市级推进录入分页查询
    qxPropelGetData(data, isAffirm) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizCountyReformSituationFill/v1/query?isAffirm=${isAffirm}`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 推进录入
    qxAdvanceEntry(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/bizCountyReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 修改
    qxAdvanceUpdate(data) {
        return new Promise((resolve, reject) => {
            req
                .put(portal + `/bizCountyReformSituationFill/v1/`, data)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },

    // 根据id查询详情
    qxGetPropelDetail(id) {
        return new Promise((resolve, reject) => {
            req
                .get(portal + `/bizCountyReformSituationFill/v1/${id}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 撤回
    qxPropelRevocation({ id, status}) {
        return new Promise((resolve, reject) => {
            req
              .post(portal + `/bizCountyReformSituationFill/v1/updateByStatus?id=${id}&status=${status}&approvalResults=2`)
              .then(res => {
                  resolve((res && res.data) || [])
              })
              .catch(err => {
                  reject(err)
              })
        })
    },
    // 区县全国肯定删除
    effectsDeleteById(data) {
        // let ids = qs.stringify({ids: data}, {arrayFormat: 'repeat'}) 
        let ids = data.join(',')
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/majorProjects/bizCountyReformSituationEffect/v1/remove/${ids}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 删除获国家支持
    nationsDeleteById(data) {
        let ids = data.join(',')
        return new Promise((resolve, reject) => {
            req
                .post(portal + `/majorProjects/bizCountyReformSituationNation/v1/remove/${ids}`)
                .then(res => {
                    resolve((res && res.data) || [])
                })
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 区县撤回
    // qxPropelRevocation(data) {
    //     let { id, status } = data
    //     return new Promise((resolve, reject) => {
    //         req
    //             .post(portal + `/bizCountyReformSituationFill/v1/updateByStatus?id=${id}&status=${status}`)
    //             .then(res => {
    //                 resolve((res && res.data) || [])
    //             })
    //             .catch(err => {
    //                 reject(err)
    //             })
    //     })
    // }
}
