package com.artfess.portal.kh.manager.impl;

import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhResultDao;
import com.artfess.portal.kh.manager.KhResultDetailsManager;
import com.artfess.portal.kh.manager.KhResultManager;
import com.artfess.portal.kh.manager.KhSchemePlanManager;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.artfess.portal.kh.model.KhResult;
import com.artfess.portal.kh.model.KhResultDetails;
import com.artfess.portal.kh.model.KhSchemePlan;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 考核结果信息 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2024-02-20
 */
@Service
public class KhResultManagerImpl extends BaseManagerImpl<KhResultDao, KhResult> implements KhResultManager {

    @Autowired
    private KhSchemePlanManager schemePlanManager;

    @Autowired
    private KhResultDetailsManager resultDetailsManager;

    @Resource
    IdGenerator idGenerator;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createResult(String planId) {
        KhSchemePlan plan = schemePlanManager.findById(planId);
        Assert.notNull(plan, "考核计划不存在");
        List<KhResult> list = Lists.newArrayList();
        List<KhResultDetails> details = Lists.newArrayList();
        plan.getPlanObjectList().forEach(khPlanObject -> {
            long id = idGenerator.nextId();
            KhResult result = new KhResult();
            result.setId(String.valueOf(id));
            result.setPlanId(planId);
            result.setSchemeId(plan.getSchemeId());
            result.setTaskName(plan.getPlanName());
            result.setStartDate(plan.getStartDate());
            result.setEndDate(plan.getEndDate());
            result.setObjType(khPlanObject.getObjType());
            result.setObjId(khPlanObject.getObjId());
            result.setObjName(khPlanObject.getObjName());
            result.setPeriod(plan.getPeriod());
            result.setAppraiserId(plan.getAppraiserId());
            result.setAppraiserName(plan.getAppraiserName());
            result.setReviewId(plan.getReviewId());
            result.setReviewName(plan.getReviewName());
            LocalDate now = LocalDate.now();
            if (plan.getStartDate().isAfter(now)) {
                result.setStatus("draft");
            } else {
                result.setStatus("edit");
            }

            list.add(result);
            plan.getScheme().getSchemeIndicatorsList().forEach(khSchemeIndicators -> {
                KhResultDetails resultDetails = new KhResultDetails();
                resultDetails.setResultId(result.getId());
                resultDetails.setSubjectId(khSchemeIndicators.getSubjectId());
                resultDetails.setNature(khSchemeIndicators.getNature());
                resultDetails.setName(khSchemeIndicators.getName());
                resultDetails.setCode(khSchemeIndicators.getCode());
                resultDetails.setContents(khSchemeIndicators.getContents());
                resultDetails.setMode(khSchemeIndicators.getMode());
                resultDetails.setTargetValue(khSchemeIndicators.getTargetValue());
                resultDetails.setUnit(khSchemeIndicators.getUnit());
                resultDetails.setWeight(khSchemeIndicators.getWeight());
                details.add(resultDetails);
            });

        });
        boolean b = this.saveBatch(list);
        if (b) {
            return resultDetailsManager.saveBatch(details);
        }

        return b;
    }

    @Override
    public KhResult findById(String id) {
        KhResult result = this.get(id);
        Assert.notNull(result, "考核结果不存在");
        LambdaQueryWrapper<KhResultDetails> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(KhResultDetails::getResultId, id);
        List<KhResultDetails> list = resultDetailsManager.list(lambdaQueryWrapper);
        result.setDetailsList(list);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(KhResult t) {
        return false;
    }

    @Override
    public boolean updateInfo(KhResult t) {
        KhResult khResult = this.get(t.getId());
        Assert.notNull(khResult, "考核结果不存在");
        khResult.setFillDate(LocalDate.now());
        khResult.setAppraiserId(t.getAppraiserId());
        khResult.setAppraiserName(t.getAppraiserName());
        khResult.setReviewId(t.getReviewId());
        khResult.setReviewName(t.getReviewName());
        khResult.setStatus(t.getStatus());
        if ("review".equals(t.getStatus())) {
            khResult.setReviewId(ContextUtil.getCurrentUserId());
            khResult.setReviewName(ContextUtil.getCurrentUserName());
        }

        if ("end".equals(t.getStatus())) {
            khResult.setAppraiserId(ContextUtil.getCurrentUserId());
            khResult.setAppraiserName(ContextUtil.getCurrentUserName());
        }
        BigDecimal totalScore = BigDecimal.ZERO;
        boolean flag = true;
        for (KhResultDetails details : t.getDetailsList()) {
            if (null != details.getActualValue() && null != details.getWeight()) {
                details.setActualScore(details.getWeight().multiply(details.getActualValue()).setScale(2, BigDecimal.ROUND_HALF_UP));
                totalScore = totalScore.add(details.getActualScore());
            } else {
                flag = false;
            }
        }
        if (flag) {
            khResult.setStatus("end");
        }
        khResult.setTotalScore(totalScore);
        KhSchemePlan plan = schemePlanManager.findById(khResult.getPlanId());
        KhAssessScheme assessScheme = plan.getAssessScheme();
        BigDecimal finalTotalScore = totalScore;
        assessScheme.getDetailsList().forEach(khAssessDetails -> {
            if (khAssessDetails.getMinValue() <= finalTotalScore.doubleValue() && khAssessDetails.getMaxValue() >= finalTotalScore.doubleValue()) {
                khResult.setLevel(khAssessDetails.getName());
            }
        });
        Assert.notNull(plan, "考核计划不存在");
        boolean update = this.updateById(khResult);
        if (update) {
            return resultDetailsManager.updateBatchById(t.getDetailsList());
        }
        return update;
    }
}
