package com.artfess.portal.util.jvm;

import lombok.Data;

/**
 * @author 陈实
 * @Package com.scaffold.common.base.jvm
 * @date 2020/5/28 8:57
 * @Description:
 */
@Data
public class ApplicationMonitorMessage {
    Integer pid;/** pid */
    String javaVersion;/** Java版本号 */
    Long runTime;/** 程序运行时间(ms) */
    Long loadedClassCount;/** JVM当前加载类数量 */
    Long unloadedClassCount;/** JVM已卸载类数量 */
    Long heapTotal;/** 堆内存大小(字节) */
    Long heapUsed;/** 堆内存已使用(字节) */
    float heapUsedPercent;/** 堆内存使用率 */
    Long nonHeapTotal;/** 堆外内存大小(字节) */
    Long nonHeapUsed;/** 堆外内存已使用(字节) */
    float nonHeapUsedPercent;/** 堆外内存使用率 */
    Long edenTotal;/** Eden区大小(字节) */
    Long edenUsed;/** Eden区已使用(字节) */
    float edenUsedPercent;/** Eden区使用率 */
    float edenPeakUsedPercent;/** Eden区使用率峰值(从上次采集统计) */
    Long survivorTotal;/** Survivor区大小(字节) */
    Long survivorUsed;/** Survivor区已使用(字节) */
    float survivorUsedPercent;/** Survivor区已使用率 */
    float survivorPeakUsedPercent;/** Survivor区已使用率峰值(从上次采集统计) */
    Long oldTotal;/** 老区大小(字节) */
    Long oldUsed;/** 老区已使用(字节) */
    float oldUsedPercent;/** 老区已使用率峰值 */
    float oldPeakUsedPercent;/** 老区已使用率峰值(从上次采集统计) */
    Long permTotal;/** 永久区大小(字节) */
    Long permUsed;/** 永久区已使用(字节) */
    float permUsedPercent;/** 永久区使用率 */
    float permPeakUsedPercent;/** 永久区使用率峰值(从上次采集统计) */
    Long codeCacheTotal;/** CodeCache区大小(字节) */
    Long codeCacheUsed;/** CodeCache区已使用(字节) */
    float codeCacheUsedPercent;/** CodeCache区使用率 */
    float codeCachePeakUsedPercent;/** CodeCache区使用率峰值(从上次采集统计) */
    String ygcName;/** young gc名称 */
    Long ygc;/** young gc次数 */
    Long ygcTime;/** young gc总时间 (ms)*/
    String fgcName;/** full gc名称 */
    Long fgc;/** full gc次数 */
    Long fgcTime;/** full gc总时间 (ms)*/
    Integer threadCount;/** JVM当前线程数量 */
    Integer threadPeakCount;/** JVM线程数量峰值 */
    Integer userThreadCount;/** JVM当前用户线程数量 */
    Integer deadLockedThreadCount;/** JVM死锁线程数量 */


}
