package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 取水类型
 */
@Getter
public enum WaterFetchEnum {
    /**
     * 删除
     */
    ONE("1", "河道内生产"),
    TWO("2", "自备水源"),
    THREE("3", "水资源配置"),
    FOUR("4", "基础设置或公用事业"),
    FIVE("5", "其他"),
    SIX("6", "蓄水")

    ;

    WaterFetchEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;



    public static String getLevel(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WaterFetchEnum[] values = values();
        StringBuffer sb = new StringBuffer();
        for (WaterFetchEnum state : values) {

            String[] split = desc.split(",");

            for(String s : split){

                if(state.getDesc().equals(s)) {
                    sb.append(",");
                    sb.append(state.getType());
                }
            }

            if(sb.length() > 0){
                return sb.substring(1);
            }
        }
        return null;
    }
}
