package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 水电站类型
 */
@Getter
public enum HystTypeEnum {
    ONE("1", "闸坝式水电站"),

    TWO("2", "引水式水电站"),

    THREE("3", "混合式水电站"),

    FOUR("4", "抽水蓄能水电站"),

    FIVE("5","潮汐能水电站"),
    ;

    HystTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        HystTypeEnum[] values = values();
        for (HystTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

}
