package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 归口管理部门
 */
@Getter
public enum AdmDepEnum {
    ONE("1", "水利部门"),

    TWO("2", "电力部门"),

    THREE("3", "农业部门"),

    FOUR("4", "林业部门"),

    FIVE("5","城建部门"),

    SIX("6","航运部门"),

    SEVEN("7","环保部门"),

    EIGHT("8","其他部门"),

    ;

    AdmDepEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        AdmDepEnum[] values = values();
        for (AdmDepEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
