package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 主要建筑物级别
 */
@Getter
public enum MainBuildGardEnum {
    ONE("1", "1956 年黄海高程"),

    TWO("2", "1985 国家高程基准"),

    THREE("3", "吴淞高程基准"),

    FOUR("4", "珠江高程基准"),

    FIVE("5", "广州高程基准"),

    SIX("6", "大沽零点高程"),

    SEVEN("7", "渤海高程"),

    EIGHT("8", "波罗的海高程"),

    NINE("9", "大连零点高程"),

    TEN("10", "废黄河零点高程"),

    ELEVEN("11", "坎门零点高程"),

    TWELVE("12", "安庆高程系"),

    THIRTEEN("13", "其他"),

    ;

    MainBuildGardEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        MainBuildGardEnum[] values = values();
        for (MainBuildGardEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
