package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 考核方案关联的指标信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@ApiModel(value="KhSchemeIndicators对象", description="考核方案关联的指标信息")
public class KhSchemeIndicators extends BaseModel<KhSchemeIndicators> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "方案ID")
    @TableField("scheme_id_")
    private String schemeId;

    @ApiModelProperty(value = "指标科目ID")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "指标性质【字典】（1：量化指标，2：非量化指标）")
    @TableField("nature_")
    private String nature;

    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "指标编码")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "指标定义(考核说明)")
    @TableField("contents_")
    private String contents;

    @ApiModelProperty(value = "计算方法（评分标准）")
    @TableField("mode_")
    private String mode;

    @ApiModelProperty(value = "目标值（非量化指标为空）")
    @TableField("target_value_")
    private BigDecimal targetValue;

    @ApiModelProperty(value = "计量单位 （非量化指标为空）")
    @TableField("unit_")
    private String unit;

    @NotNull(message = "请输入权重值", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "权重值（不大于1）")
    @TableField("weight_")
    private BigDecimal weight;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "指标科目名称")
    @TableField(exist = false)
    private String subjectName;

}
