package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 监测站类型
 */
@Getter
public enum WarnTypeEnum {
    /**
     *
     */
    YL("1", "雨量"),

    RESSW("2", "水库"),

    BASSW("3", "河道"),

    SL("4", "渗流"),

    SY("5", "渗压"),

    WY("6", "位移"),
    ;

    WarnTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        WarnTypeEnum[] values = values();
        for (WarnTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

}
