package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 工程规模
 */
@Getter
public enum EngScalTypeEnum {
    ONE("1", "小 (1) 型"),

    TWO("2", "小 (2) 型"),

    THREE("3", "中型"),

    ;

    EngScalTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        EngScalTypeEnum[] values = values();
        for (EngScalTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
