package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 堤防类型
 */
@Getter
public enum DikeTypeEnum {
    ONE("1", "河 (江) 堤"),

    TWO("2", "湖堤"),

    THREE("3", "海堤"),

    FOUR("4", "围 (圩、 圈)"),

    FIVE("5", "护岸工程"),

    ;

    DikeTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        DikeTypeEnum[] values = values();
        for (DikeTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
