package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 水源类型
 */
@Getter
public enum WaterTakeSourceEnum {
    /**
     * 删除
     */
    ONE("1", "地表水"),

    TWO("2", "地下水"),

    THREE("3", "地下水地热水"),

    FOUR("4","地下水矿泉水"),

    FIVE("5", "矿泉水"),

    SIX("6","江河地表水"),

    SEVEN("7","河水"),

    EIGHT("8","普通地下水"),

    NINE("9","水库地表水"),

    TEN("10","其他地表水"),



            ;

    WaterTakeSourceEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WaterTakeSourceEnum[] values = values();
        for (WaterTakeSourceEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
