package com.artfess.base.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 监测站类型
 */
@Getter
public enum DamTypeEnum {
    /**
     *
     */
    HN("1", "混凝土坝"),

    NYHN("2", "碾压混凝土坝"),

    JQS("3", "浆砌石坝"),

    T("4", "土坝"),

    DS("5", "堆石坝"),

    OTHER("9", "其他"),
    ;

    DamTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static List<String> hnDam(){
        List<String> hnDam = Lists.newArrayList();
        hnDam.add(DamTypeEnum.HN.type);
        hnDam.add(DamTypeEnum.NYHN.type);
        return hnDam;
    }

    public static List<String> tsDam(){
        List<String> hnDam = Lists.newArrayList();
        hnDam.add(DamTypeEnum.JQS.type);
        hnDam.add(DamTypeEnum.T.type);
        hnDam.add(DamTypeEnum.DS.type);
        return hnDam;
    }

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        DamTypeEnum[] values = values();
        for (DamTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

}
