package com.artfess.ljzc.welfare.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.welfare.manager.AssetPubilcInfoManager;
import com.artfess.ljzc.welfare.model.AssetPubilcInfo;
import com.artfess.ljzc.welfare.vo.AssetPubilcInfoVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 公益资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@RestController
@RequestMapping("/biz/assetPubilc/pubilcInfo/v1/")
@Api(tags = "公益资产信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AssetPubilcInfoController extends BaseController<AssetPubilcInfoManager, AssetPubilcInfo> {


    @PostMapping(value="/queryPagePubilcInfoAuthority", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询公益资产")
    public PageList<AssetPubilcInfoVo> queryPageCompanyAuthority(@RequestBody QueryFilter<AssetPubilcInfo> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("i.belongs_org_full_id_",ContextUtil.getCurrentOrgFullId(), QueryOP.RIGHT_LIKE);
        }
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("i.asset_type_", Direction.ASC));
        sorter.add(new FieldSort("i.belongs_org_id_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return baseService.queryPubilcInfoVoPage(queryFilter);
    }

    @PostMapping("/insertPubilcInfo")
    @ApiOperation("保存公益资产")
    public CommonResult<String> insertPubilcInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetPubilcInfo assetPubilcInfo) throws Exception {
        String id = this.baseService.insertPubilcInfo(assetPubilcInfo);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"保存成功！",id);
    }

    @PostMapping("/updatePubilcInfo")
    @ApiOperation("修改公益资产")
    public CommonResult<String> updatePubilcInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetPubilcInfo assetPubilcInfo) throws Exception {
        boolean result = baseService.updatePubilcInfo(assetPubilcInfo);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deletePubilcInfo")
    @ApiOperation("删除公益资产")
    public CommonResult<String> deletePubilcInfo(@ApiParam(name="id", value="id") @RequestParam String id) {
        boolean result = baseService.deletePubilcInfo(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deleteBachPubilcInfo")
    @ApiOperation("批量删除公益资产")
    public CommonResult<String> deleteBachPubilcInfo(@ApiParam(name="ids", value="ids") @RequestParam String... ids) {
        boolean result = baseService.deleteBachPubilcInfo(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/findById")
    @ApiOperation(value = "根据id查询公益资产")
    public AssetPubilcInfo findById(@RequestParam(name = "id",required = true) String id) {
        AssetPubilcInfo pubilcInfo =baseService.findPubilcInfo(id);
        return pubilcInfo;
    }

    @PostMapping("/auditLoan")
    @ApiOperation(value = "审核公益资产入库")
    public CommonResult<String> auditLoan(@ApiParam(name = "status", value = "入库审核状态（0：未审核，1：已审核）")@RequestParam String status,
                                          @ApiParam(name = "msg", value = "审核意见")@RequestParam String msg,
                                          @ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.auditLoan(status,msg,Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "审核失败");
        }
        return new CommonResult<>();

    }
}
