package com.artfess.ljzc.stock.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 股权资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-11-27
 */
@TableName("Biz_Asset_Stock_Info")
@ApiModel(value="BAssetStockInfo对象", description="股权资产信息")
public class AssetStockInfo extends AutoFillFullModel<AssetStockInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "股权公司名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "股权公司营业执照编号")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "股权公司详细地址")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "股权公司性质（字典：二级控股子公司，二级全资子公司，二级参股子公司，有限合伙企业，三级全资子公司，三级控股子公司，三级参股子公司）")
    @TableField("asset_nature_")
    private String assetNature;

    @ApiModelProperty(value = "股权公司注册资金（万元）")
    @TableField("registered_capital_")
    private BigDecimal registeredCapital;

    @ApiModelProperty(value = "股权公司成立日期")
    @TableField("establish_date_")
    private String establishDate;

    @ApiModelProperty(value = "股权占比（%）")
    @TableField("equity_ratio_")
    private BigDecimal equityRatio;

    @ApiModelProperty(value = "出资方式（字典：资金，技术）")
    @TableField("investment_ways_")
    private String investmentWays;

    @ApiModelProperty(value = "认缴金额（万元）")
    @TableField("investment_money_")
    private BigDecimal investmentMoney;

    @ApiModelProperty(value = "实际认缴（万元）")
    @TableField("investment_actual_money_")
    private BigDecimal investmentActualMoney;

    @ApiModelProperty(value = "股权归属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "股权归属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "股权归属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "董事会信息")
    @TableField("directors_")
    private String directors;

    @ApiModelProperty(value = "高管信息")
    @TableField("executives_")
    private String executives;

    @ApiModelProperty(value = "监事会信息")
    @TableField("visitors_")
    private String visitors;

    @ApiModelProperty(value = "外派管理人员")
    @TableField("expatriate_")
    private String expatriate;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "资产审核状态（-1：驳回 0：草稿，1：待审核，2：审核通过）")
    @TableField("asset_audit_")
    private String assetAudit;


    @ApiModelProperty(value = "资产审核意见")
    @TableField("audit_msg_")
    private String auditMsg;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("is_dele_")
    private String isDele = "0";




    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAssetNature() {
        return assetNature;
    }

    public void setAssetNature(String assetNature) {
        this.assetNature = assetNature;
    }

    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public String getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(String establishDate) {
        this.establishDate = establishDate;
    }

    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }

    public String getInvestmentWays() {
        return investmentWays;
    }

    public void setInvestmentWays(String investmentWays) {
        this.investmentWays = investmentWays;
    }

    public BigDecimal getInvestmentMoney() {
        return investmentMoney;
    }

    public void setInvestmentMoney(BigDecimal investmentMoney) {
        this.investmentMoney = investmentMoney;
    }

    public BigDecimal getInvestmentActualMoney() {
        return investmentActualMoney;
    }

    public void setInvestmentActualMoney(BigDecimal investmentActualMoney) {
        this.investmentActualMoney = investmentActualMoney;
    }

    public String getBelongsOrgId() {
        return belongsOrgId;
    }

    public void setBelongsOrgId(String belongsOrgId) {
        this.belongsOrgId = belongsOrgId;
    }

    public String getBelongsOrgName() {
        return belongsOrgName;
    }

    public void setBelongsOrgName(String belongsOrgName) {
        this.belongsOrgName = belongsOrgName;
    }

    public String getBelongsOrgFullId() {
        return belongsOrgFullId;
    }

    public void setBelongsOrgFullId(String belongsOrgFullId) {
        this.belongsOrgFullId = belongsOrgFullId;
    }

    public String getDirectors() {
        return directors;
    }

    public void setDirectors(String directors) {
        this.directors = directors;
    }

    public String getExecutives() {
        return executives;
    }

    public void setExecutives(String executives) {
        this.executives = executives;
    }

    public String getVisitors() {
        return visitors;
    }

    public void setVisitors(String visitors) {
        this.visitors = visitors;
    }

    public String getExpatriate() {
        return expatriate;
    }

    public void setExpatriate(String expatriate) {
        this.expatriate = expatriate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAssetAudit() {
        return assetAudit;
    }

    public void setAssetAudit(String assetAudit) {
        this.assetAudit = assetAudit;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }



    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetStockInfo{" +
            "id=" + id +
            ", name=" + name +
            ", code=" + code +
            ", address=" + address +
            ", assetNature=" + assetNature +
            ", registeredCapital=" + registeredCapital +
            ", establishDate=" + establishDate +
            ", equityRatio=" + equityRatio +
            ", investmentWays=" + investmentWays +
            ", investmentMoney=" + investmentMoney +
            ", investmentActualMoney=" + investmentActualMoney +
            ", belongsOrgId=" + belongsOrgId +
            ", belongsOrgName=" + belongsOrgName +
            ", belongsOrgFullId=" + belongsOrgFullId +
            ", directors=" + directors +
            ", executives=" + executives +
            ", visitors=" + visitors +
            ", expatriate=" + expatriate +
            ", remark=" + remark +
            ", assetAudit=" + assetAudit +
            ", auditMsg=" + auditMsg+
            ", isDele=" + isDele +

        "}";
    }
}
