package com.artfess.ljzc.intangible.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.ljzc.intangible.model.BizAssetIntangibleInfo;
import com.artfess.ljzc.intangible.manager.BizAssetIntangibleInfoManager;

import java.util.Arrays;

/**
 * 无形资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@Api(tags = "无形资产-资产信息")
@RestController
@RequestMapping("/biz/assetIntangibleInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizAssetIntangibleInfoController extends BaseController<BizAssetIntangibleInfoManager, BizAssetIntangibleInfo> {

    @GetMapping("/audit")
    @ApiOperation("批量审核")
    public CommonResult<String> auditAsset(@ApiParam(name = "status", value = "审核状态")  @RequestParam String status,
                                           @ApiParam(name = "assetMsg", value = "审核意见")  @RequestParam String assetMsg,
                                           @ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.audit(Arrays.asList(ids), status, assetMsg);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizAssetIntangibleInfo> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizAssetIntangibleInfo> queryFilter) {
        String fullId = ContextUtil.getCurrentOrgFullId();
        queryFilter.addFilter("belongs_org_full_id_", fullId, QueryOP.RIGHT_LIKE);
        return baseService.query(queryFilter);
    }
}
