package com.artfess.ljzc.fixed.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 固定资产库存信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@ApiModel(value="BizAssetFixedInventory对象", description="固定资产库存信息")
public class BizAssetFixedInventory extends BaseModel<BizAssetFixedInventory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资产类型ID")
    @TableField("type_id_")
    private String typeId;

    @ApiModelProperty(value = "资产ID")
    @TableField("fixed_id_")
    private String fixedId;

    @ApiModelProperty(value = "当前库存量")
    @TableField("quantity_")
    private Integer quantity;

    @ApiModelProperty(value = "剩余价值（元）")
    @TableField("amount_")
    private BigDecimal amount;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("last_time_")
    private Long lastTime;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getFixedId() {
        return fixedId;
    }

    public void setFixedId(String fixedId) {
        this.fixedId = fixedId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetFixedInventory{" +
            "id=" + id +
            ", typeId=" + typeId +
            ", fixedId=" + fixedId +
            ", quantity=" + quantity +
            ", amount=" + amount +
            ", lastTime=" + lastTime +
            ", tenantId=" + tenantId +
        "}";
    }
}
