package com.artfess.ljzc.stock.model;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 股权结构信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-11-27
 */
@TableName("biz_asset_stock_structure")
@ApiModel(value="AssetStockStructure对象", description="股权结构信息")
public class AssetStockStructure extends BaseModel<AssetStockStructure> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "股权id")
    @TableField("stock_id_")
    private String stockId;

    @ApiModelProperty(value = "股权公司名称")
    @TableField("stock_name_")
    private String stockName;

    @ApiModelProperty(value = "股权占比（%）")
    @TableField("equity_ratio_")
    private BigDecimal equityRatio;

    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStockId() {
        return stockId;
    }

    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    public String getStockName() {
        return stockName;
    }

    public void setStockName(String stockName) {
        this.stockName = stockName;
    }

    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }

    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }



    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetStockStructure{" +
            "id=" + id +
            ", stockId=" + stockId +
            ", stockName=" + stockName +
            ", equityRatio=" + equityRatio +
            ", lastTime=" + lastTime +
        "}";
    }
}
