package com.artfess.ljzc.loan.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.ljzc.loan.manager.AssetLoanInfoManager;
import com.artfess.ljzc.loan.model.AssetLoanInfo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 债权资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@RestController
@RequestMapping("/biz/loan/loanInfo/v1/")
@Api(tags = "债权资产信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class AssetLoanInfoController extends BaseController<AssetLoanInfoManager, AssetLoanInfo> {

    @PostMapping(value="/queryPageLoanInfoAuthority", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询债权资产")
    public PageList<AssetLoanInfo> queryPageCompanyAuthority(@RequestBody QueryFilter<AssetLoanInfo> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("belongs_org_full_id_",ContextUtil.getCurrentOrgFullId(), QueryOP.RIGHT_LIKE);
        }
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("end_date_", Direction.DESC));
        sorter.add(new FieldSort("belongs_org_id_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return baseService.query(queryFilter);
    }

    @PostMapping("/insertLoanInfo")
    @ApiOperation("保存债权资产")
    public CommonResult<String> insertLoanInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetLoanInfo assetLoanInfo) throws Exception {
        String id = this.baseService.insertLoanInfo(assetLoanInfo);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"保存成功！",id);
    }

    @PostMapping("/updateLoanInfo")
    @ApiOperation("修改债权资产")
    public CommonResult<String> updateLoanInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetLoanInfo assetLoanInfo) throws Exception {
        boolean result = baseService.updateLoanInfo(assetLoanInfo);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deleteLoanInfo")
    @ApiOperation("删除债权资产")
    public CommonResult<String> deleteLoanInfo(@ApiParam(name="id", value="id") @RequestParam String id) {
        boolean result = baseService.deleteLoanInfo(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deleteBachLoanInfo")
    @ApiOperation("批量删除债权资产")
    public CommonResult<String> deleteBachLoanInfo(@ApiParam(name="ids", value="ids") @RequestParam String... ids) {
        boolean result = baseService.deleteBachLoanInfo(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/findById")
    @ApiOperation(value = "根据id查询债权资产")
    public AssetLoanInfo findById(@RequestParam(name = "id",required = true) String id) {
        AssetLoanInfo loanInfo =baseService.findLoanInfo(id);
        return loanInfo;
    }

    @PostMapping("/auditLoan")
    @ApiOperation(value = "审核债权资产入库")
    public CommonResult<String> auditLoan(@ApiParam(name = "status", value = "入库审核状态（0：未审核，1：已审核）")@RequestParam String status,
                                          @ApiParam(name = "msg", value = "审核意见")@RequestParam String msg,
                                          @ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.auditLoan(status,msg,Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "审核失败");
        }
        return new CommonResult<>();

    }
}
