import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '变更状态',
            prop: 'status',
            type: 'select',
            options: [
                { name: '草稿', value: '0' },
                { name: '待审核', value: '1' },
                { name: '审核中', value: '2' },
                { name: '已完成', value: '4' },
                { name: '取消', value: '3' }
            ],
            value: '',
            span: 4
        },
        {
            title: '创建时间',
            prop: 'createTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '申请人',
            prop: 'changeInitiatorName',
            minWidth: 130,
            sortable: true
        },
        {
            title: '变更类型',
            prop: 'changeType',
            minWidth: 120,
            sortable: true
        },
        {
            title: '变更前描述',
            prop: 'beforeChangeContent',
            minWidth: 120,
            sortable: true
        },
        {
            title: '变更后描述',
            prop: 'afterChangeContent',
            minWidth: 120,
            sortable: true
        },
        {
            title: '变更原因',
            prop: 'changeReason',
            minWidth: 200,
            sortable: true
        },
        {
            title: '变更状态',
            prop: 'status',
            minWidth: 120,
            render:true,
            sortable: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
