import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '评价体系名称',
            prop: 'valuationConfigurationName',
            type: 'input',
            value: ''
        },
        {
            title: '评价年度',
            prop: 'assessmentYear',
            type: 'date',
            dateOption: {
                type: 'year',
                format: 'YYYY',
                valueFormat: 'YYYY',
            },
            span: 4,
            value: ''
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '评价类型',
            prop: 'assessmentType',
            type: 'select',
            options: [
                { name: '年度评价', value: '3' },
                { name: '季度评价', value: '2' },
                { name: '月度评价', value: '1' }
            ],
            value: '',
            span: 4
        },
        {
            title: '状态',
            prop: 'eva.STATUS_',
            type: 'select',
            options: [
                { name: '待评分', value: '0' },
                { name: '评分中', value: '1' },
                { name: '已评分', value: '2' },
            ],
            value: '',
            span: 4
        },
    ]
    const columnsList: COption[] = [
        {
            title: '评价体系名称',
            prop: 'valuationConfigurationName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '评价年度',
            prop: 'assessmentYear',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '评价类型',
            prop: 'assessmentType',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '评价周期',
            prop: 'assessment',
            minWidth: 120,
            render: true,
            sortable: true
        },
        {
            title: '状态',
            prop: 'isOpt',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true,
            render: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
