package com.artfess.base.conf;

import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

@Component
public class AdminConfig {

    public static final List<String> ADMIN_ORG_CODES =
            Arrays.asList("00001513", "00003625", "00001689");

    // 改为静态变量
    //管理公司编号
    private static String adminCompanyCode =  "00001689";
    //管理公司名称
    private static String adminCompanyName =  "重庆卓越实业发展有限公司";
    //管理公司合同签署人
    private static String adminReceiverName = "杨雪";
    //管理公司合同签署人联系方式
    private static String adminReceiverContact = "13635498501";

    public static boolean isAdmin(String vendorCode) {
        return ADMIN_ORG_CODES.contains(vendorCode);
    }

    public static String getAdminCompanyName() {
        return adminCompanyName;
    }

    public static String getAdminCompanyCode() {
        return adminCompanyCode;
    }

    public static String getAdminReceiverName() {
        return adminReceiverName;
    }

    public static String getAdminReceiverContact() {
        return adminReceiverContact;
    }


    public static void setAdminCompanyName(String companyName) {
        adminCompanyName = companyName;
    }

    public static void setAdminCompanyCode(String companyCode) {
        adminCompanyCode = companyCode;
    }


    public static void setAdminReceiverName(String name) {
        adminReceiverName = name;
    }

    public static void setAdminReceiverContact(String contact) {
        adminReceiverContact = contact;
    }


}