/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.file.config.FileUploadSetting;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.util.MinioUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadM3u8 {
    private static final Logger log = LoggerFactory.getLogger(UploadM3u8.class);

    public String uploadVideoToM3U8(DefaultFile defaultFile) {
        InputStream inputStream = null;
        if (DefaultFile.SAVE_TYPE_MINIO.equals(defaultFile.getStoreType())) {
            inputStream = MinioUtil.getMinioFile(null, defaultFile.getFilePath(), true);
        }
        String filename = defaultFile.getFileName();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(new Date());
        String uuid = defaultFile.getId();
        FileUploadSetting fileUploadSetting = (FileUploadSetting)AppUtil.getBean(FileUploadSetting.class);
        String basepath = fileUploadSetting.getBasepath();
        String videoFilePath = basepath + File.separator + "video" + File.separator + date + File.separator + uuid + File.separator + filename;
        try {
            File video = new File(videoFilePath);
            if (!video.exists()) {
                FileUtil.createFolder((String)videoFilePath, (boolean)true);
                FileUtil.writeFile((String)videoFilePath, (InputStream)inputStream);
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File m3u8 = new File(basepath + File.separator + "video" + File.separator + date + File.separator + uuid + File.separator + defaultFile.getId() + ".m3u8");
        try {
            m3u8.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("videoFilePath\uff1a{},m3u8Path:{}", (Object)videoFilePath, (Object)m3u8.getPath());
        String hls_time = "10";
        ProcessBuilder pb = new ProcessBuilder("ffmpeg", "-i", videoFilePath, "-codec", "copy", "-start_number", "0", "-hls_time", hls_time, "-hls_list_size", "0", "-f", "hls", m3u8.getPath());
        pb.redirectErrorStream(true);
        Process p = null;
        try {
            String line;
            p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u89c6\u9891\u8f6c\u6362\u5931\u8d25\uff1afileId:{},\u5931\u8d25\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)defaultFile.getId(), (Object)e.getMessage());
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String tempUrl = "/m3u8/video" + File.separator + date + File.separator + uuid + File.separator + defaultFile.getId() + ".m3u8";
        return tempUrl.replace("\\", "/");
    }
}

