package com.artfess.base.enums;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author min.wu
 * @date 2022-10-25
 */
@AllArgsConstructor
@Getter
@ApiModel("考试状态")
public enum QuestionStateEnum {
    //栏目类型枚举类枚举值
    notTo("未开考", "0"),
    toBeAnswer("未答卷", "1"),
    inTest("考试中", "2"),
    haveTest("已交卷", "3"),
    ;
    private String desc;
    private String type;



    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        QuestionStateEnum[] values = values();
        for (QuestionStateEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
