/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.dao.BizMaterialCategoryDao;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.vo.MatCategoryVo;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class BizMaterialCategoryManagerImpl
extends BaseManagerImpl<BizMaterialCategoryDao, BizMaterialCategory>
implements BizMaterialCategoryManager {
    @Value(value="${zsj.getEnterpriseCategotyUrl}")
    private String zsjGetEnterpriseCategotyUrl;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private PlatMaterialManager platMaterialManager;

    @Override
    public List<BizMaterialCategory> selectTree() {
        LambdaQueryWrapper allQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)allQW.eq(BizModel::getIsDele, (Object)"0")).orderByAsc(BizMaterialCategory::getCode);
        List categories = super.list((Wrapper)allQW);
        if (BeanUtils.isEmpty((Object)categories) || categories.size() <= 0) {
            return new ArrayList<BizMaterialCategory>();
        }
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(this.getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public PageList<BizMaterialCategory> queryAllByPage(QueryFilter<BizMaterialCategory> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizMaterialCategory> result = ((BizMaterialCategoryDao)this.baseMapper).queryAllByPage((IPage<BizMaterialCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizMaterialCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public List<BizMaterialCategory> getEnterpriseCategoryTree() {
        List categories;
        ArrayList codeList;
        block9: {
            codeList = new ArrayList();
            if (BizUtils.isAdmin(this.ucFeignService)) {
                try {
                    JSONObject param = new JSONObject();
                    param.set("companyCode", (Object)ContextUtil.getCurrentGroup().getGroupCode());
                    JSONObject codeListObj = this.foreignCallService.callInterfaceResponse(this.zsjGetEnterpriseCategotyUrl, param, 1);
                    if (codeListObj.get((Object)"code").equals("0")) {
                        if (BeanUtils.isNotEmpty((Object)codeListObj.get((Object)"data"))) {
                            codeList.addAll(JSONUtil.toList((JSONArray)codeListObj.getJSONArray((Object)"data"), String.class));
                        }
                        break block9;
                    }
                    if (BeanUtils.isNotEmpty((Object)codeListObj.get((Object)"msg"))) {
                        throw new BaseException(codeListObj.getStr((Object)"msg"));
                    }
                    throw new BaseException(codeListObj.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u67e5\u8be2\u4e3b\u6570\u636e\u4f01\u4e1a\u6388\u6743\u5206\u7c7b\u5931\u8d25\uff1a" + e.getMessage());
                    return new ArrayList<BizMaterialCategory>();
                }
            }
        }
        LambdaQueryWrapper allQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)allQW.eq(BizModel::getIsDele, (Object)"0")).orderByAsc(BizMaterialCategory::getCode);
        if (codeList.size() > 0) {
            allQW.in(BizMaterialCategory::getCode, codeList);
        }
        if (BeanUtils.isEmpty((Object)(categories = super.list((Wrapper)allQW))) || categories.size() <= 0) {
            return new ArrayList<BizMaterialCategory>();
        }
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(this.getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public List<BizMaterialCategory> getEnterpriseCategoryTree(String companyCode) {
        ArrayList codeList;
        block8: {
            codeList = new ArrayList();
            try {
                JSONObject param = new JSONObject();
                param.set("companyCode", (Object)companyCode);
                JSONObject codeListObj = this.foreignCallService.callInterfaceResponse(this.zsjGetEnterpriseCategotyUrl, param, 1);
                if (codeListObj.get((Object)"code").equals("0")) {
                    if (BeanUtils.isNotEmpty((Object)codeListObj.get((Object)"data"))) {
                        codeList.addAll(JSONUtil.toList((JSONArray)codeListObj.getJSONArray((Object)"data"), String.class));
                    }
                    break block8;
                }
                if (BeanUtils.isNotEmpty((Object)codeListObj.get((Object)"msg"))) {
                    throw new BaseException(codeListObj.getStr((Object)"msg"));
                }
                throw new BaseException(codeListObj.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u67e5\u8be2\u4e3b\u6570\u636e\u4f01\u4e1a\u6388\u6743\u5206\u7c7b\u5931\u8d25\uff1a" + e.getMessage());
                return new ArrayList<BizMaterialCategory>();
            }
        }
        if (codeList.size() <= 0) {
            return new ArrayList<BizMaterialCategory>();
        }
        LambdaQueryWrapper allQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)allQW.eq(BizModel::getIsDele, (Object)"0")).in(BizMaterialCategory::getCode, codeList);
        List categories = super.list((Wrapper)allQW);
        if (BeanUtils.isEmpty((Object)categories) || categories.size() <= 0) {
            return new ArrayList<BizMaterialCategory>();
        }
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(this.getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public void exportExcelData(QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u7269\u6599\u5206\u7c7b-\u5bfc\u51fa\u6570\u636e";
        List data = this.queryAllByPage(queryFilter).getRows();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BizMaterialCategory.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    @Transactional
    public void updateYqcCategory(BizMaterialCategory entity) {
        super.updateById((Object)entity);
        if (BeanUtils.isNotEmpty((Object)entity.getYqcCategoryCode())) {
            LambdaUpdateWrapper childrenCateUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)childrenCateUW.set(BizMaterialCategory::getYqcCategoryCode, (Object)entity.getYqcCategoryCode())).set(BizMaterialCategory::getYqcCategoryName, (Object)entity.getYqcCategoryName())).likeRight(BizMaterialCategory::getCode, (Object)entity.getCode())).eq(BizModel::getIsDele, (Object)"0");
            super.update((Wrapper)childrenCateUW);
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMaterialCategory entity) {
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)hisQW.eq(BizMaterialCategory::getCode, (Object)entity.getCode())).eq(BizModel::getIsDele, (Object)"0");
            int count = super.count((Wrapper)hisQW);
            if (count > 0) {
                throw new BaseException("\u3010" + entity.getCode() + "\u3011\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            super.save((Object)entity);
            LambdaUpdateWrapper childrenUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)childrenUW.set(BizMaterialCategory::getHasChildren, (Object)1)).eq(BizMaterialCategory::getId, (Object)entity.getParentId());
            super.update((Wrapper)childrenUW);
        } else {
            super.updateById((Object)entity);
            if (BeanUtils.isNotEmpty((Object)entity.getYqcCategoryCode())) {
                LambdaUpdateWrapper childrenCateUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)childrenCateUW.set(BizMaterialCategory::getYqcCategoryCode, (Object)entity.getYqcCategoryCode())).set(BizMaterialCategory::getYqcCategoryName, (Object)entity.getYqcCategoryName())).likeRight(BizMaterialCategory::getCode, (Object)entity.getCode())).eq(BizModel::getIsDele, (Object)"0");
                super.update((Wrapper)childrenCateUW);
            }
        }
    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = "";
        try {
            LambdaQueryWrapper catQW = new LambdaQueryWrapper();
            List paramList = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), MatCategoryVo.class);
            int count = 0;
            ArrayList<MatCategoryVo> newCate = new ArrayList<MatCategoryVo>();
            List data = paramList.stream().sorted(new Comparator<MatCategoryVo>(){

                @Override
                public int compare(MatCategoryVo o1, MatCategoryVo o2) {
                    return o1.getCatNo().length() - o2.getCatNo().length();
                }
            }).collect(Collectors.toList());
            for (MatCategoryVo temp : data) {
                ((LambdaQueryWrapper)catQW.eq(BizMaterialCategory::getCode, (Object)temp.getCatNo())).eq(BizModel::getIsDele, (Object)"0");
                count = super.count((Wrapper)catQW);
                if (0 == count) {
                    newCate.add(temp);
                } else {
                    LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizMaterialCategory::getName, (Object)temp.getCatName())).set(BizMaterialCategory::getStatus, (Object)temp.getStatus())).eq(BizMaterialCategory::getCode, (Object)temp.getCatNo())).eq(BizModel::getIsDele, (Object)"0");
                    super.update((Wrapper)uw);
                }
                catQW.clear();
            }
            if (newCate.size() > 0) {
                for (MatCategoryVo temp : newCate) {
                    BizMaterialCategory category = new BizMaterialCategory();
                    ((LambdaQueryWrapper)catQW.select(new SFunction[]{BizMaterialCategory::getId}).eq(BizMaterialCategory::getCode, (Object)temp.getCatNo().subSequence(0, temp.getCatNo().length() - 2))).eq(BizModel::getIsDele, (Object)"0");
                    BizMaterialCategory fcat = (BizMaterialCategory)((Object)((BizMaterialCategoryDao)this.baseMapper).selectOne((Wrapper)catQW));
                    if (BeanUtils.isNotEmpty((Object)((Object)fcat))) {
                        category.setParentId(fcat.getId());
                    } else {
                        category.setParentId("0");
                    }
                    if (BeanUtils.isNotEmpty((Object)temp.getCatFno())) {
                        category.setParentCode(temp.getCatFno());
                    }
                    category.setCode(temp.getCatNo());
                    category.setName(temp.getCatName());
                    if (BeanUtils.isNotEmpty((Object)temp.getStatus())) {
                        category.setStatus(temp.getStatus());
                    } else {
                        category.setStatus(1);
                    }
                    super.save((Object)category);
                    catQW.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }

    @Override
    @Transactional
    public void updateStatus(List<String> ids, String status) {
        if (status.equals("0")) {
            List categoryList = super.listByIds(ids);
            for (BizMaterialCategory category : categoryList) {
                LambdaQueryWrapper platMaterialQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)platMaterialQW.eq(PlatMaterial::getMatCategory, (Object)category.getCode())).eq(BizModel::getIsDele, (Object)"0");
                if (this.platMaterialManager.count((Wrapper)platMaterialQW) > 0) {
                    throw new BaseException("\u5206\u7c7b\u7f16\u53f7\u3010" + category.getCode() + "\u3011\u4e0b\u5b58\u5728\u5e73\u53f0\u7269\u6599\uff0c\u65e0\u6cd5\u7981\u7528");
                }
                LambdaQueryWrapper materialQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)materialQW.eq(BizMaterial::getMatCategory, (Object)category.getCode())).eq(BizModel::getIsDele, (Object)"0");
                if (this.materialManager.count((Wrapper)materialQW) <= 0) continue;
                throw new BaseException("\u5206\u7c7b\u7f16\u53f7\u3010" + category.getCode() + "\u3011\u4e0b\u5b58\u5728\u4f01\u4e1a\u7269\u6599\uff0c\u65e0\u6cd5\u7981\u7528");
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(BizMaterialCategory::getStatus, (Object)status)).in(BizMaterialCategory::getId, ids)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    private List<BizMaterialCategory> getchildren(BizMaterialCategory root, List<BizMaterialCategory> list) {
        List<BizMaterialCategory> children = list.stream().filter(category -> category.getParentId().equals(root.getId())).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(children) && children.size() > 0) {
            for (BizMaterialCategory c : children) {
                c.setChildren(this.getchildren(c, list));
            }
        }
        return children;
    }
}

