package com.artfess.cgpt.winbind.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 中标公示记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizWinBiddingNoticePublicity对象", description="中标公示记录表")
public class BizWinBiddingNoticePublicity extends BaseModel<BizWinBiddingNoticePublicity> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "标的类型（1：物资，2：项目）")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "采购申请明细ID")
    @TableField("PURCHASING_APPLICATION_DETAIL_ID_")
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "采购立项ID（关联项目立项表ID）")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项明细ID")
    @TableField("NOTICE_DETAIL_ID_")
    private String noticeDetailId;

    @ApiModelProperty(value = "编制人ID")
    @TableField("PREPARED_ID_")
    private String preparedId;

    @ApiModelProperty(value = "编制人名称")
    @TableField("PREPARED_NAME_")
    private String preparedName;

    @ApiModelProperty(value = "编制时间")
    @TableField("PREPARED_TIME_")
    private LocalDateTime preparedTime;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "供应商公司ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "公示标题")
    @TableField("PUBLICITY_TITLE_")
    private String publicityTitle;

    @ApiModelProperty(value = "公示内容")
    @TableField("PUBLICITY_CONTENT_")
    private String publicityContent;

    @ApiModelProperty(value = "公示范围（使用字典，1：对所有人公示，2：只向中标方公示，3：指定企业）")
    @TableField("PUBLICITY_RANGE_")
    private String publicityRange;

    @ApiModelProperty(value = "采购方式（1：平台定价，2：合同采购，3：企业线下定价【单一采购】）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "采购类型（1：招标采购，2：询比价采购，3：竞价采购， 4：竞争性谈判，5：单一来源采购，6：多源采购，7：框架协议， 8：邀请招标采购）")
    @TableField("PROCURE_TYPE_")
    private String procureType;

    @ApiModelProperty(value = "公示开始时间")
    @TableField("PUBLICITY_START_TIME_")
    private LocalDateTime publicityStartTime;

    @ApiModelProperty(value = "公示结束时间")
    @TableField("PUBLICITY_END_TIME_")
    private LocalDateTime publicityEndTime;

    @ApiModelProperty(value = "状态（1.已公示，2.已下架）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "招标方式（1：招标采购，2：询比价采购，3：竞价采购， 4：竞争性谈判，5：单一来源采购，6：多源采购，7：框架协议， 8：邀请招标采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private String isTax;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "评标方式（1.最低价评标法，2.综合评标法）")
    @TableField("EVALUATION_METHOD_")
    private Integer evaluationMethod;

    @ApiModelProperty(value = "招标状态（1：未开标，2：已开标，3：流标，4：已评标，5：待企业确认， 6：待供应商确认，7：已中标，8：已发布中选公示，9：合同已签订）")
    @TableField("BID_STATUS_")
    private Integer bidStatus;

    @ApiModelProperty(value = "评标类型（1.按物料评标，2.按供应商评标）")
    @TableField("EVALUATION_TYPE_")
    private Integer evaluationType;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS")
    private String unloadAddress;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(String noticeType) {
        this.noticeType = noticeType;
    }
    public String getPurchasingApplicationDetailId() {
        return purchasingApplicationDetailId;
    }

    public void setPurchasingApplicationDetailId(String purchasingApplicationDetailId) {
        this.purchasingApplicationDetailId = purchasingApplicationDetailId;
    }
    public String getPurchasingApplicationId() {
        return purchasingApplicationId;
    }

    public void setPurchasingApplicationId(String purchasingApplicationId) {
        this.purchasingApplicationId = purchasingApplicationId;
    }
    public String getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }
    public String getNoticeDetailId() {
        return noticeDetailId;
    }

    public void setNoticeDetailId(String noticeDetailId) {
        this.noticeDetailId = noticeDetailId;
    }
    public String getPreparedId() {
        return preparedId;
    }

    public void setPreparedId(String preparedId) {
        this.preparedId = preparedId;
    }
    public String getPreparedName() {
        return preparedName;
    }

    public void setPreparedName(String preparedName) {
        this.preparedName = preparedName;
    }
    public LocalDateTime getPreparedTime() {
        return preparedTime;
    }

    public void setPreparedTime(LocalDateTime preparedTime) {
        this.preparedTime = preparedTime;
    }
    public String getProcureOrgId() {
        return procureOrgId;
    }

    public void setProcureOrgId(String procureOrgId) {
        this.procureOrgId = procureOrgId;
    }
    public String getProcureOrgCode() {
        return procureOrgCode;
    }

    public void setProcureOrgCode(String procureOrgCode) {
        this.procureOrgCode = procureOrgCode;
    }
    public String getProcureOrgName() {
        return procureOrgName;
    }

    public void setProcureOrgName(String procureOrgName) {
        this.procureOrgName = procureOrgName;
    }
    public String getVendorId() {
        return vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }
    public String getVendorCode() {
        return vendorCode;
    }

    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }
    public String getVendorName() {
        return vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }
    public String getPublicityTitle() {
        return publicityTitle;
    }

    public void setPublicityTitle(String publicityTitle) {
        this.publicityTitle = publicityTitle;
    }
    public String getPublicityContent() {
        return publicityContent;
    }

    public void setPublicityContent(String publicityContent) {
        this.publicityContent = publicityContent;
    }
    public String getPublicityRange() {
        return publicityRange;
    }

    public void setPublicityRange(String publicityRange) {
        this.publicityRange = publicityRange;
    }
    public String getProcurementMethod() {
        return procurementMethod;
    }

    public void setProcurementMethod(String procurementMethod) {
        this.procurementMethod = procurementMethod;
    }
    public String getProcureType() {
        return procureType;
    }

    public void setProcureType(String procureType) {
        this.procureType = procureType;
    }
    public LocalDateTime getPublicityStartTime() {
        return publicityStartTime;
    }

    public void setPublicityStartTime(LocalDateTime publicityStartTime) {
        this.publicityStartTime = publicityStartTime;
    }
    public LocalDateTime getPublicityEndTime() {
        return publicityEndTime;
    }

    public void setPublicityEndTime(LocalDateTime publicityEndTime) {
        this.publicityEndTime = publicityEndTime;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getMatId() {
        return matId;
    }

    public void setMatId(String matId) {
        this.matId = matId;
    }
    public String getMatPlatcode() {
        return matPlatcode;
    }

    public void setMatPlatcode(String matPlatcode) {
        this.matPlatcode = matPlatcode;
    }
    public String getMatCategoryCode() {
        return matCategoryCode;
    }

    public void setMatCategoryCode(String matCategoryCode) {
        this.matCategoryCode = matCategoryCode;
    }
    public String getMatCode() {
        return matCode;
    }

    public void setMatCode(String matCode) {
        this.matCode = matCode;
    }
    public String getMatName() {
        return matName;
    }

    public void setMatName(String matName) {
        this.matName = matName;
    }
    public String getMatMaterial() {
        return matMaterial;
    }

    public void setMatMaterial(String matMaterial) {
        this.matMaterial = matMaterial;
    }
    public String getMatSpec() {
        return matSpec;
    }

    public void setMatSpec(String matSpec) {
        this.matSpec = matSpec;
    }
    public BigDecimal getMatNum() {
        return matNum;
    }

    public void setMatNum(BigDecimal matNum) {
        this.matNum = matNum;
    }
    public String getMatUnit() {
        return matUnit;
    }

    public void setMatUnit(String matUnit) {
        this.matUnit = matUnit;
    }
    public String getApplicationMethod() {
        return applicationMethod;
    }

    public void setApplicationMethod(String applicationMethod) {
        this.applicationMethod = applicationMethod;
    }
    public LocalDate getDemandDate() {
        return demandDate;
    }

    public void setDemandDate(LocalDate demandDate) {
        this.demandDate = demandDate;
    }
    public String getHasQualification() {
        return hasQualification;
    }

    public void setHasQualification(String hasQualification) {
        this.hasQualification = hasQualification;
    }
    public BigDecimal getPlannedPrice() {
        return plannedPrice;
    }

    public void setPlannedPrice(BigDecimal plannedPrice) {
        this.plannedPrice = plannedPrice;
    }
    public String getMatBrand() {
        return matBrand;
    }

    public void setMatBrand(String matBrand) {
        this.matBrand = matBrand;
    }
    public String getMatBaseExt() {
        return matBaseExt;
    }

    public void setMatBaseExt(String matBaseExt) {
        this.matBaseExt = matBaseExt;
    }
    public String getMatOtherExt() {
        return matOtherExt;
    }

    public void setMatOtherExt(String matOtherExt) {
        this.matOtherExt = matOtherExt;
    }
    public String getIsTax() {
        return isTax;
    }

    public void setIsTax(String isTax) {
        this.isTax = isTax;
    }
    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }
    public Integer getEvaluationMethod() {
        return evaluationMethod;
    }

    public void setEvaluationMethod(Integer evaluationMethod) {
        this.evaluationMethod = evaluationMethod;
    }
    public Integer getBidStatus() {
        return bidStatus;
    }

    public void setBidStatus(Integer bidStatus) {
        this.bidStatus = bidStatus;
    }
    public Integer getEvaluationType() {
        return evaluationType;
    }

    public void setEvaluationType(Integer evaluationType) {
        this.evaluationType = evaluationType;
    }
    public String getUnloadAddress() {
        return unloadAddress;
    }

    public void setUnloadAddress(String unloadAddress) {
        this.unloadAddress = unloadAddress;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(String createDeptId) {
        this.createDeptId = createDeptId;
    }
    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateDeptId() {
        return updateDeptId;
    }

    public void setUpdateDeptId(String updateDeptId) {
        this.updateDeptId = updateDeptId;
    }
    public String getUpdateDeptName() {
        return updateDeptName;
    }

    public void setUpdateDeptName(String updateDeptName) {
        this.updateDeptName = updateDeptName;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizWinBiddingNoticePublicity{" +
            "id=" + id +
            ", noticeType=" + noticeType +
            ", purchasingApplicationDetailId=" + purchasingApplicationDetailId +
            ", purchasingApplicationId=" + purchasingApplicationId +
            ", noticeId=" + noticeId +
            ", noticeDetailId=" + noticeDetailId +
            ", preparedId=" + preparedId +
            ", preparedName=" + preparedName +
            ", preparedTime=" + preparedTime +
            ", procureOrgId=" + procureOrgId +
            ", procureOrgCode=" + procureOrgCode +
            ", procureOrgName=" + procureOrgName +
            ", vendorId=" + vendorId +
            ", vendorCode=" + vendorCode +
            ", vendorName=" + vendorName +
            ", publicityTitle=" + publicityTitle +
            ", publicityContent=" + publicityContent +
            ", publicityRange=" + publicityRange +
            ", procurementMethod=" + procurementMethod +
            ", procureType=" + procureType +
            ", publicityStartTime=" + publicityStartTime +
            ", publicityEndTime=" + publicityEndTime +
            ", status=" + status +
            ", matId=" + matId +
            ", matPlatcode=" + matPlatcode +
            ", matCategoryCode=" + matCategoryCode +
            ", matCode=" + matCode +
            ", matName=" + matName +
            ", matMaterial=" + matMaterial +
            ", matSpec=" + matSpec +
            ", matNum=" + matNum +
            ", matUnit=" + matUnit +
            ", applicationMethod=" + applicationMethod +
            ", demandDate=" + demandDate +
            ", hasQualification=" + hasQualification +
            ", plannedPrice=" + plannedPrice +
            ", matBrand=" + matBrand +
            ", matBaseExt=" + matBaseExt +
            ", matOtherExt=" + matOtherExt +
            ", isTax=" + isTax +
            ", taxRate=" + taxRate +
            ", evaluationMethod=" + evaluationMethod +
            ", bidStatus=" + bidStatus +
            ", evaluationType=" + evaluationType +
            ", unloadAddress=" + unloadAddress +
            ", remarks=" + remarks +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptId=" + updateDeptId +
            ", updateDeptName=" + updateDeptName +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
