package com.artfess.cgpt.winbind.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.BizDeliveryAddress;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.cgpt.winbind.dao.BizWinBiddingNoticeDetaileDao;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 中标通知确认记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizWinBiddingNoticeDetaileManagerImpl extends BaseManagerImpl<BizWinBiddingNoticeDetaileDao, BizWinBiddingNoticeDetaile> implements BizWinBiddingNoticeDetaileManager {

    @Autowired
    private BizViolateRecordManager violateRecordManager;
    @Autowired
    private BizViolateRecordDetailManager violateRecordDetailManager;
    @Autowired
    private BizWinBiddingNoticeManager winBidNoticeManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailsManager;
    @Autowired
    private PlatMaterialManager platMaterialManager;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager projectApprovalDetailsManager;

    @Override
    public List<BizWinBiddingNoticeDetaile> getByPid(String pid) {
        LambdaQueryWrapper<BizWinBiddingNoticeDetaile> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizWinBiddingNoticeDetaile::getWinNoticeId,pid);
        List<BizWinBiddingNoticeDetaile> list = this.list(queryWrapper);
        return list;
    }

    @Override
    @Transactional
    public void removeByPid(String pid) {
        LambdaQueryWrapper<BizWinBiddingNoticeDetaile> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizWinBiddingNoticeDetaile::getWinNoticeId,pid);
        this.remove(wrapper);
    }

    //2024-08-29 17:50
//    @Override
//    @Transactional
//    public void updateStatusById(String ids, Integer status) {
//        List<String> idList = Arrays.asList(ids.split(","));
//
//        LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> winNoticeDetailUW = new LambdaUpdateWrapper<>();
//        winNoticeDetailUW.set(BizWinBiddingNoticeDetaile::getStatus,status)
//                .set(BizWinBiddingNoticeDetaile::getConfirmTime,LocalDateTime.now())
//                .in(BizWinBiddingNoticeDetaile::getId,idList);
//        super.update(winNoticeDetailUW);
//
//        BizWinBiddingNotice winNotice = winBidNoticeManager.getById(super.getById(idList.get(0)).getWinNoticeId());
//        Integer noticeType = winNotice.getNoticeType();
//        MatApproval matNotice = matApprovalManager.getById(winNotice.getNoticeId());
//        ProjectApproval proNotice = projectApprovalManager.getById(winNotice.getNoticeId());
//
//        //查询成交通知明细是否全部确认完成
//        LambdaQueryWrapper<BizWinBiddingNoticeDetaile> countQW = new LambdaQueryWrapper<>();
//        countQW.eq(BizWinBiddingNoticeDetaile::getStatus,2)
//                .eq(BizWinBiddingNoticeDetaile::getWinNoticeId,winNotice.getId());
//
//        if(super.count(countQW)==0){
//            //如果全部确认完成完成-》更新成交通知状态为已确认
//            winNotice.setStatus(status);
//            winNotice.setConfirmTime(LocalDateTime.now());
//            winBidNoticeManager.updateById(winNotice);
//
//            //如果状态为已确认，查询立项是否全部确认完成
//            LambdaQueryWrapper<BizWinBiddingNotice> winNoticeCountQW = new LambdaQueryWrapper<>();
//            winNoticeCountQW.eq(BizWinBiddingNotice::getStatus,2)
//                    .eq(BizWinBiddingNotice::getNoticeId,winNotice.getNoticeId())
//                    .eq(BizWinBiddingNotice::getIsDele,"0");
//            if(super.count(countQW)==0){
//                //如果全部确认完成完成-》更新立项状态为已中标
//                if(noticeType==1){
//                    //物资
//                    matNotice.setBidStatus(7);
//                    matApprovalManager.updateById(matNotice);
//                }else {
//                    //项目
//                    proNotice.setBidStatus(7);
//                    projectApprovalManager.updateById(proNotice);
//                }
//
//            }
//        }
//
//        if(status==1){
//            //同意
//            //更新立项明细表状态为已中标
//            List<BizWinBiddingNoticeDetaile> winBiddingNoticeDetailList = super.listByIds(idList);
//            List<String> noticeDetailIds = winBiddingNoticeDetailList.stream().map(s -> s.getNoticeDetailedId()).collect(Collectors.toList());
//
//            if(noticeType==1){
//                //物资
//                LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
//                noticeDetailUW.set(MatApprovalDetails::getBidStatus,5)
//                        .in(MatApprovalDetails::getId,noticeDetailIds)
//                        .eq(MatApprovalDetails::getIsDele,"0");
//                matApprovalDetailsManager.update(noticeDetailUW);
//            }else {
//                //项目
//                LambdaUpdateWrapper<ProjectApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
//                noticeDetailUW.set(ProjectApprovalDetails::getBidStatus,5)
//                        .in(ProjectApprovalDetails::getId,noticeDetailIds)
//                        .eq(ProjectApprovalDetails::getIsDele,"0");
//                projectApprovalDetailsManager.update(noticeDetailUW);
//            }
//
//        }
//
//        if(status==4){
//            List<BizViolateRecordDetail> violateRecordDetailList = new ArrayList<>();
//            //不同意
//            IUser currentUser = ContextUtil.getCurrentUser();
//
//            //生成违约记录
//            BizViolateRecord violateRecord = new BizViolateRecord();
//            if(noticeType==1){
//                //物资
//                violateRecord.setNoticeId(matNotice.getId());
//                violateRecord.setNoticeCode(matNotice.getProjectNumber());
//                violateRecord.setNoticeTitle(matNotice.getNoticeTitle());
//                violateRecord.setMatOrgId(matNotice.getProcureOrgId());
//                violateRecord.setMatOrgCode(matNotice.getProcureOrgCode());
//                violateRecord.setMatOrgName(matNotice.getProcureOrgName());
//                if(BeanUtils.isNotEmpty(matNotice.getAffiliatedUserName())){
//                    violateRecord.setMatContacts(matNotice.getAffiliatedUserName());
//                }
//                if(BeanUtils.isNotEmpty(matNotice.getContactsPhone())){
//                    violateRecord.setMatContactsPhone(matNotice.getContactsPhone());
//                }
//            }else {
//                //项目
//                violateRecord.setNoticeId(proNotice.getId());
//                violateRecord.setNoticeCode(proNotice.getNoticeCode());
//                violateRecord.setNoticeTitle(proNotice.getNoticeTitle());
//                violateRecord.setMatOrgId(proNotice.getProcureOrgId());
//                violateRecord.setMatOrgCode(proNotice.getProcureOrgCode());
//                violateRecord.setMatOrgName(proNotice.getProcureOrgName());
//                if(BeanUtils.isNotEmpty(proNotice.getAffiliatedUserName())){
//                    violateRecord.setMatContacts(proNotice.getAffiliatedUserName());
//                }
//                if(BeanUtils.isNotEmpty(proNotice.getContactsPhone())){
//                    violateRecord.setMatContactsPhone(proNotice.getContactsPhone());
//                }
//            }
//            violateRecord.setSupplierOrgId(winNotice.getVendorId());
//            violateRecord.setSupplierOrgCode(winNotice.getVendorCode());
//            violateRecord.setSupplierOrgName(winNotice.getVendorName());
//            violateRecord.setUserId(currentUser.getUserId());
//            violateRecord.setUserAccount(currentUser.getAccount());
//            violateRecord.setUserName(currentUser.getFullname());
//            if(BeanUtils.isNotEmpty(currentUser.getMobile())){
//                violateRecord.setUserMobile(currentUser.getMobile());
//            }
//            violateRecord.setOrgId(violateRecord.getSupplierOrgId());
//            violateRecord.setOrgCode(violateRecord.getSupplierOrgCode());
//            violateRecord.setOrgName(violateRecord.getSupplierOrgName());
//            violateRecord.setProcureType(winNotice.getProcureType());
//            violateRecord.setNoticeType(winNotice.getNoticeType());
//            violateRecord.setViolateType(2);
//
//            //查询参与表，供应商该立项缴纳的保证金
//            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
//            userParticipationQW.eq(UserParticipation::getCompanyId,winNotice.getVendorId())
//                    .eq(UserParticipation::getNoticeId,winNotice.getNoticeId())
//                    .eq(UserParticipation::getNoticeType,winNotice.getNoticeType())
//                    .eq(UserParticipation::getStatus,1)
//                    .eq(UserParticipation::getIsDele,"0")
//                    .orderByDesc(UserParticipation::getParticipationDate)
//                    .last("limit 1");
//            UserParticipation userParticipation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);
//
//            if(BeanUtil.isEmpty(userParticipation)){
//                throw new BaseException("未找到参与数据，请联系管理员处理");
//            }
//
//            violateRecord.setViolatePrice(userParticipation.getPrice());
//            violateRecord.setViolateTime(LocalDateTime.now());
//            violateRecord.setPayStatus(1);
//            violateRecord.setRevokeStatus(1);
//            violateRecord.setWinNoticeId(winNotice.getId());
//            violateRecord.setHandleStatus(1);
//            violateRecordManager.save(violateRecord);
//            //生成违约明细记录
//            idList.stream().forEach(s->{
//                BizWinBiddingNoticeDetaile winNoticeDetail = super.getById(s);
//                BizViolateRecordDetail violateRecordDetail = new BizViolateRecordDetail();
//                violateRecordDetail.setVrId(violateRecord.getId());
//                violateRecordDetail.setNoticeId(violateRecord.getNoticeId());
//                violateRecordDetail.setNoticeCode(violateRecord.getNoticeCode());
//                violateRecordDetail.setNoticeTitle(violateRecord.getNoticeTitle());
//                violateRecordDetail.setNoticeDetailId(winNoticeDetail.getNoticeDetailedId());
//                violateRecordDetail.setMatCategoryCode(winNoticeDetail.getMatCategoryCode());
//                violateRecordDetail.setMatId(winNoticeDetail.getMatId());
//                violateRecordDetail.setMatPlatcode(winNoticeDetail.getMatPlatcode());
//                violateRecordDetail.setMatName(winNoticeDetail.getMatName());
//                violateRecordDetail.setMatMaterial(winNoticeDetail.getMatMaterial());
//                violateRecordDetail.setMatSpec(winNoticeDetail.getMatSpec());
//                violateRecordDetail.setMatUnit(winNoticeDetail.getMatUnit());
//                violateRecordDetail.setMatBaseExt(winNoticeDetail.getMatBaseExt());
//                violateRecordDetail.setMatOtherExt(winNoticeDetail.getMatOtherExt());
//                violateRecordDetail.setMatBrand(winNoticeDetail.getMatBrand());
//                violateRecordDetail.setNum(winNoticeDetail.getMatNum());
//                violateRecordDetail.setTaxRate(winNoticeDetail.getTaxRate());
//                violateRecordDetail.setApplicationMethod(winNoticeDetail.getApplicationMethod());
//                violateRecordDetail.setHasQualifications(winNoticeDetail.getHasQualification());
//                violateRecordDetail.setTransactionPrice(winNoticeDetail.getWinBidPrice());
//                violateRecordDetail.setTransactionAmount(winNoticeDetail.getWinBidAmount());
//                violateRecordDetailList.add(violateRecordDetail);
//            });
//            violateRecordDetailManager.saveBatch(violateRecordDetailList);
//       }
//
//    }

    @Override
    @Transactional
    public void updateStatusById(String ids, Integer status) {
        List<String> idList = Arrays.asList(ids.split(","));

        LambdaUpdateWrapper<BizWinBiddingNoticeDetaile> winNoticeDetailUW = new LambdaUpdateWrapper<>();
        winNoticeDetailUW.set(BizWinBiddingNoticeDetaile::getStatus,status)
                .set(BizWinBiddingNoticeDetaile::getConfirmTime,LocalDateTime.now())
                .in(BizWinBiddingNoticeDetaile::getId,idList);
        super.update(winNoticeDetailUW);

        BizWinBiddingNotice winNotice = winBidNoticeManager.getById(super.getById(idList.get(0)).getWinNoticeId());
        Integer noticeType = winNotice.getNoticeType();
        MatApproval matNotice = matApprovalManager.getById(winNotice.getNoticeId());
        ProjectApproval proNotice = projectApprovalManager.getById(winNotice.getNoticeId());

        //查询成交通知明细是否全部确认完成
        LambdaQueryWrapper<BizWinBiddingNoticeDetaile> countQW = new LambdaQueryWrapper<>();
        countQW.eq(BizWinBiddingNoticeDetaile::getStatus,2)
                .eq(BizWinBiddingNoticeDetaile::getWinNoticeId,winNotice.getId());

        if(super.count(countQW)==0){
            //如果全部确认完成完成-》更新成交通知状态为已确认
            winNotice.setStatus(status);
            winNotice.setConfirmTime(LocalDateTime.now());
            winBidNoticeManager.updateById(winNotice);

            //如果状态为已确认，查询立项是否全部确认完成
            LambdaQueryWrapper<BizWinBiddingNotice> winNoticeCountQW = new LambdaQueryWrapper<>();
            winNoticeCountQW.eq(BizWinBiddingNotice::getStatus,2)
                    .eq(BizWinBiddingNotice::getNoticeId,winNotice.getNoticeId())
                    .eq(BizWinBiddingNotice::getIsDele,"0");
            if(super.count(countQW)==0){
                //如果全部确认完成完成-》更新立项状态为已中标
                if(noticeType==1){
                    //物资
                    matNotice.setWinNoticeStatus(2);
                    matApprovalManager.updateById(matNotice);
                }else {
                    //项目
                    proNotice.setWinNoticeStatus(2);
                    projectApprovalManager.updateById(proNotice);
                }

            }
        }

        if(status==1){
            //同意
            //更新立项明细表状态为已中标
            List<BizWinBiddingNoticeDetaile> winBiddingNoticeDetailList = super.listByIds(idList);
            List<String> noticeDetailIds = winBiddingNoticeDetailList.stream().map(s -> s.getNoticeDetailedId()).collect(Collectors.toList());

            if(noticeType==1){
                //物资
                LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                noticeDetailUW.set(MatApprovalDetails::getBidStatus,5)
                        .in(MatApprovalDetails::getId,noticeDetailIds)
                        .eq(MatApprovalDetails::getIsDele,"0");
                matApprovalDetailsManager.update(noticeDetailUW);
            }else {
                //项目
                LambdaUpdateWrapper<ProjectApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
                noticeDetailUW.set(ProjectApprovalDetails::getBidStatus,5)
                        .in(ProjectApprovalDetails::getId,noticeDetailIds)
                        .eq(ProjectApprovalDetails::getIsDele,"0");
                projectApprovalDetailsManager.update(noticeDetailUW);
            }

        }

        if(status==4){
            List<BizViolateRecordDetail> violateRecordDetailList = new ArrayList<>();
            //不同意
            IUser currentUser = ContextUtil.getCurrentUser();

            //生成违约记录
            BizViolateRecord violateRecord = new BizViolateRecord();
            if(noticeType==1){
                //物资
                violateRecord.setNoticeId(matNotice.getId());
                violateRecord.setNoticeCode(matNotice.getProjectNumber());
                violateRecord.setNoticeTitle(matNotice.getNoticeTitle());
                violateRecord.setMatOrgId(matNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(matNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(matNotice.getProcureOrgName());
                if(BeanUtils.isNotEmpty(matNotice.getAffiliatedUserName())){
                    violateRecord.setMatContacts(matNotice.getAffiliatedUserName());
                }
                if(BeanUtils.isNotEmpty(matNotice.getContactsPhone())){
                    violateRecord.setMatContactsPhone(matNotice.getContactsPhone());
                }
            }else {
                //项目
                violateRecord.setNoticeId(proNotice.getId());
                violateRecord.setNoticeCode(proNotice.getNoticeCode());
                violateRecord.setNoticeTitle(proNotice.getNoticeTitle());
                violateRecord.setMatOrgId(proNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(proNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(proNotice.getProcureOrgName());
                if(BeanUtils.isNotEmpty(proNotice.getAffiliatedUserName())){
                    violateRecord.setMatContacts(proNotice.getAffiliatedUserName());
                }
                if(BeanUtils.isNotEmpty(proNotice.getContactsPhone())){
                    violateRecord.setMatContactsPhone(proNotice.getContactsPhone());
                }
            }
            violateRecord.setSupplierOrgId(winNotice.getVendorId());
            violateRecord.setSupplierOrgCode(winNotice.getVendorCode());
            violateRecord.setSupplierOrgName(winNotice.getVendorName());
            violateRecord.setUserId(currentUser.getUserId());
            violateRecord.setUserAccount(currentUser.getAccount());
            violateRecord.setUserName(currentUser.getFullname());
            if(BeanUtils.isNotEmpty(currentUser.getMobile())){
                violateRecord.setUserMobile(currentUser.getMobile());
            }
            violateRecord.setOrgId(violateRecord.getSupplierOrgId());
            violateRecord.setOrgCode(violateRecord.getSupplierOrgCode());
            violateRecord.setOrgName(violateRecord.getSupplierOrgName());
            violateRecord.setProcureType(winNotice.getProcureType());
            violateRecord.setNoticeType(winNotice.getNoticeType());
            violateRecord.setViolateType(2);

            //查询参与表，供应商该立项缴纳的保证金
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.eq(UserParticipation::getCompanyId,winNotice.getVendorId())
                    .eq(UserParticipation::getNoticeId,winNotice.getNoticeId())
                    .eq(UserParticipation::getNoticeType,winNotice.getNoticeType())
                    .eq(UserParticipation::getStatus,1)
                    .eq(UserParticipation::getIsDele,"0")
                    .orderByDesc(UserParticipation::getParticipationDate)
                    .last("limit 1");
            UserParticipation userParticipation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);

            if(BeanUtil.isEmpty(userParticipation)){
                throw new BaseException("未找到参与数据，请联系管理员处理");
            }

            violateRecord.setViolatePrice(userParticipation.getPrice());
            violateRecord.setViolateTime(LocalDateTime.now());
            violateRecord.setPayStatus(1);
            violateRecord.setRevokeStatus(1);
            violateRecord.setWinNoticeId(winNotice.getId());
            violateRecord.setHandleStatus(1);
            violateRecordManager.save(violateRecord);
            //生成违约明细记录
            idList.stream().forEach(s->{
                BizWinBiddingNoticeDetaile winNoticeDetail = super.getById(s);
                BizViolateRecordDetail violateRecordDetail = new BizViolateRecordDetail();
                violateRecordDetail.setVrId(violateRecord.getId());
                violateRecordDetail.setNoticeId(violateRecord.getNoticeId());
                violateRecordDetail.setNoticeCode(violateRecord.getNoticeCode());
                violateRecordDetail.setNoticeTitle(violateRecord.getNoticeTitle());
                violateRecordDetail.setNoticeDetailId(winNoticeDetail.getNoticeDetailedId());
                violateRecordDetail.setMatCategoryCode(winNoticeDetail.getMatCategoryCode());
                violateRecordDetail.setMatId(winNoticeDetail.getMatId());
                violateRecordDetail.setMatPlatcode(winNoticeDetail.getMatPlatcode());
                violateRecordDetail.setMatName(winNoticeDetail.getMatName());
                violateRecordDetail.setMatMaterial(winNoticeDetail.getMatMaterial());
                violateRecordDetail.setMatSpec(winNoticeDetail.getMatSpec());
                violateRecordDetail.setMatUnit(winNoticeDetail.getMatUnit());
                violateRecordDetail.setMatBaseExt(winNoticeDetail.getMatBaseExt());
                violateRecordDetail.setMatOtherExt(winNoticeDetail.getMatOtherExt());
                violateRecordDetail.setMatBrand(winNoticeDetail.getMatBrand());
                violateRecordDetail.setNum(winNoticeDetail.getMatNum());
                violateRecordDetail.setTaxRate(winNoticeDetail.getTaxRate());
                violateRecordDetail.setApplicationMethod(winNoticeDetail.getApplicationMethod());
                violateRecordDetail.setHasQualifications(winNoticeDetail.getHasQualification());
                violateRecordDetail.setTransactionPrice(winNoticeDetail.getWinBidPrice());
                violateRecordDetail.setTransactionAmount(winNoticeDetail.getWinBidAmount());
                violateRecordDetailList.add(violateRecordDetail);
            });
            violateRecordDetailManager.saveBatch(violateRecordDetailList);
        }

    }

    @Override
    public PageList<BizWinBiddingNoticeDetaile> queryJoinMasterByPage(QueryFilter<BizWinBiddingNoticeDetaile> queryFilter) {
        queryFilter.addFilter("b.IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizWinBiddingNoticeDetaile> result = baseMapper.queryJoinMasterByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public List<BizWinBiddingNoticeDetaile> excelToData(MultipartFile file) throws Exception {
        List<BizWinBiddingNoticeDetaile> data = ExcelImportUtil.importExcel(file.getInputStream(), BizWinBiddingNoticeDetaile.class, new ImportParams());
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(BizWinBiddingNoticeDetaile temp :data){
                //1.根据平台物料编号查询物料表
                if (BeanUtils.isEmpty(temp.getMatPlatcode())) {
                    throw new BaseException("请填入平台物料编号");
                }

                IGroup org = ContextUtil.getCurrentGroup();
                Enterprise enterprise = enterpriseManager.getByOrgIdOrCode(org.getGroupId(), org.getGroupCode());
                if(BeanUtils.isEmpty(enterprise)){
                    throw new BaseException("当前企业信息未找到，请前往主数据推送企业");
                }

                temp.setMatPlatcode(temp.getMatPlatcode().trim());

                LambdaQueryWrapper<BizMaterial> materialQW = new LambdaQueryWrapper<>();
                materialQW.eq(BizMaterial::getMatPlatcode,temp.getMatPlatcode())
                        .and(s->s.eq(BizMaterial::getMatCompanyCode,enterprise.getCompanyCode())
                                .or(BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode()))
                                .eq(BizMaterial::getMatCompanyCode,enterprise.getHistoryCompanyCode()))
                        .eq(BizMaterial::getIsDele,"0")
                        .orderByDesc(BizMaterial::getCreateTime)
                        .last("limit 1");
                BizMaterial material = materialManager.getBaseMapper().selectOne(materialQW);
                if(BeanUtils.isEmpty(material)){
                    throw new BaseException("平台物料编号【"+temp.getMatPlatcode()+"】未找到企业物料，请输入正确的平台物料编号或生成企业物料");
                }
//                if(BeanUtils.isNotEmpty(temp.getDemandDateValue())){
//                    temp.setDemandDate(LocalDate.parse(temp.getDemandDateValue()));
//                }
                //赋值物料属性
                temp.setMatId(material.getId());
                temp.setMatCategoryCode(material.getMatCategory());
                temp.setMatCode(material.getMatCode());
                temp.setMatName(material.getMatName());
                temp.setMatMaterial(material.getMatMaterial());
                temp.setMatSpec(material.getMatSpec());
                temp.setMatBrand(material.getMatBrand());
                temp.setMatBaseExt(material.getMatBaseExt());
                temp.setMatOtherExt(material.getMatOtherExt());
                temp.setMatUnit(material.getMatUnit());
                temp.setTaxRate(material.getMatTaxrate());
                temp.setApplicationMethod(5);

                //根据送货地址编号获取地址
//                if(BeanUtils.isNotEmpty(temp.getUnloadAddress())){
//                    LambdaQueryWrapper<BizDeliveryAddress> addressQW = new LambdaQueryWrapper<>();
//                    addressQW.eq(BizDeliveryAddress::getEnterpriseId, ContextUtil.getCurrentOrgId())
//                            .eq(BizDeliveryAddress::getCode,temp.getUnloadAddress())
//                            .eq(BizDeliveryAddress::getIsDele,"0")
//                            .orderByDesc(BizDeliveryAddress::getCreateTime)
//                            .last("limit 1");
//                    BizDeliveryAddress address = addressManager.getBaseMapper().selectOne(addressQW);
//                    if(BeanUtils.isNotEmpty(address)){
//                        temp.setUnloadAddress(address.getEnterpriseContactAddress());
//                    }
//                }

            }
        }

        return data;
    }

}
