package com.artfess.cgpt.winbind.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.cgpt.winbind.vo.BiddingNoticeVo;

import java.util.List;

/**
 * 中标记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizWinBiddingNoticeManager extends BaseManager<BizWinBiddingNotice> {

    /**
     * 根据id批量删除
     * @param ids
     * @return
     */
    void removeIdList(List<String> ids);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizWinBiddingNotice getDetailById(String id);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(BizWinBiddingNotice entity);

    /**
     * 更新状态
     * @param id
     * @param status
     */
    void updateStatus(String id, Integer status);

    /**
     * 发布成交通知（物资）
     * @param entity
     */
    void pushWinBidNotice(BizWinBiddingNotice entity);

    /**
     * 发布成交通知（项目）
     * @param entity
     */
    void pushWinBidNoticePro(BizWinBiddingNotice entity);

    /**
     * 去重查询成交供应商
     * @param queryFilter
     * @return
     */
    PageList<BizWinBiddingNotice> getWinBidVendor(QueryFilter<BizWinBiddingNotice> queryFilter);

}
