package com.artfess.cgpt.violate.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 竞价违约记录明细表
 *
 * @Dept 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizViolateRecordDetail对象", description="竞价违约记录明细表")
@Data
@TableName("biz_violate_record_detail")
public class BizViolateRecordDetail extends BizNoModel<BizViolateRecordDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "违约记录ID")
    @TableField("VR_ID_")
    private String vrId;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项明细ID")
    @TableField("NOTICE_DETAIL_ID_")
    private String noticeDetailId;

    @ApiModelProperty(value = "物料分类ID，（关联物料分类ID）")
    @TableField("MAT_CATEGORY_ID_")
    private String matCategoryId;

    @ApiModelProperty(value = "物料分类编码")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料分类NAME，（关联物料分类名称）")
    @TableField("MAT_CATEGORY_NAME_")
    private String matCategoryName;

    @ApiModelProperty(value = "竞价申请ID（关联竞价申请表ID）")
    @TableField("HANDLE_DETAILED_ID_")
    private String handleDetailedId;

    @ApiModelProperty(value = "物料ID，（关联企业物料表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料对应NAME,（关联物料表名称）")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "数量")
    @TableField("NUM_")
    private BigDecimal num;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "招标方式，关联立项采购类型（1：招标采购，2：询比价采购，3：竞价采购，"
            +"4：竞争性谈判，5：单一来源采购，6：多源采购，7：框架协议，"
            +"8：邀请招标采购）")
    @TableField("APPLICATION_METHOD_")
    private Integer applicationMethod;

    @ApiModelProperty(value = "有无资质要求（1：无，2：有）")
    @TableField("HAS_QUALIFICATIONS_")
    private Integer hasQualifications;

    @ApiModelProperty(value = "报价单价（元）")
    @TableField("TRANSACTION_PRICE_")
    private BigDecimal transactionPrice;

    @ApiModelProperty(value = "报价金额（元）")
    @TableField("TRANSACTION_AMOUNT_")
    private BigDecimal transactionAmount;

    @ApiModelProperty(value = "保证金（元）")
    @TableField("BOND_")
    private BigDecimal bond;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
